/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.update;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.CopilotPlugin;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.update.UpdaterChecker2021_1;
import com.github.copilot.update.UpdaterCheckerFrom2021_2;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotPluginUpdater {
    private static final Logger LOG = Logger.getInstance(CopilotPluginUpdater.class);

    @RequiresEdt
    private static void notifyUpdateAvailable(@NotNull Project project) {
        Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("pluginUpdate.updateNotification.title"), CopilotBundle.get("pluginUpdate.updateNotification.message"), NotificationType.IDE_UPDATE, true);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CopilotBundle.get("pluginUpdate.updateNotification.installButton"), () -> ApplicationManager.getApplication().executeOnPooledThread(() -> CopilotPluginUpdater.installCopilotUpdate(project))));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CopilotBundle.get("pluginUpdate.restartNotification.hideButton"), () -> {
            CopilotApplicationSettings.settings().checkForUpdate = false;
        }));
        notification.notify(project);
    }

    @RequiresEdt
    private static void notifyUpdateUnavailable(@NotNull Project project) {
        Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("pluginUpdate.noUpdateNotification.title"), CopilotBundle.get("pluginUpdate.noUpdateNotification.message"), NotificationType.IDE_UPDATE, true);
        notification.addAction((AnAction)CopilotPluginUpdater.createHideNotificationAction());
        notification.notify(project);
    }

    @RequiresBackgroundThread
    private static void installCopilotUpdate(@NotNull Project project) {
        UpdateSettings settingsCopy = new UpdateSettings();
        settingsCopy.getState().copyFrom((BaseState)UpdateSettings.getInstance().getState());
        settingsCopy.getState().setCheckNeeded(true);
        settingsCopy.getState().setPluginsCheckNeeded(true);
        settingsCopy.getState().setThirdPartyPluginsAllowed(true);
        settingsCopy.getState().setShowWhatsNewEditor(false);
        UpdateChecker.updateAndShowResult((Project)project, (UpdateSettings)settingsCopy);
    }

    @NotNull
    private static Collection<PluginDownloader> findAvailableUpdates(@NotNull ProgressIndicator indicator) {
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() == 211) {
            return UpdaterChecker2021_1.findAvailableUpdates(indicator);
        }
        return UpdaterCheckerFrom2021_2.findAvailableUpdates(indicator);
    }

    @Nullable
    private static PluginDownloader findCopilotUpdate(@NotNull Collection<PluginDownloader> availableUpdates) {
        return availableUpdates.stream().filter(p -> CopilotPlugin.COPILOT_ID.equals((Object)p.getId())).findFirst().orElse(null);
    }

    @NotNull
    private static NotificationAction createHideNotificationAction() {
        String label = CopilotBundle.get("pluginUpdate.notification.hideButton");
        return NotificationAction.createSimpleExpiring((String)label, (Runnable)EmptyRunnable.INSTANCE);
    }

    public static final class CheckUpdatesTask
    extends Task.Backgroundable {
        private final boolean notifyNoUpdate;

        public CheckUpdatesTask(@NotNull Project project) {
            this(project, false);
        }

        public CheckUpdatesTask(@NotNull Project project, boolean notifyNoUpdate) {
            super(project, CopilotBundle.get("pluginUpdate.checkUpdateTask.title"), true);
            this.notifyNoUpdate = notifyNoUpdate;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (this.myProject.isDisposed()) {
                return;
            }
            try {
                boolean updateAvailable;
                Collection<PluginDownloader> availableUpdates = CopilotPluginUpdater.findAvailableUpdates(indicator);
                boolean bl = updateAvailable = CopilotPluginUpdater.findCopilotUpdate(availableUpdates) != null;
                if (updateAvailable) {
                    StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> CopilotPluginUpdater.notifyUpdateAvailable(this.myProject));
                } else if (this.notifyNoUpdate) {
                    StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> CopilotPluginUpdater.notifyUpdateUnavailable(this.myProject));
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to check for plugin updates", (Throwable)e);
            }
        }
    }
}

