/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.update;

import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotLocalApplicationSettings;
import com.github.copilot.update.CopilotPluginUpdater;
import com.github.copilot.util.ApplicationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0097@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/copilot/update/CopilotUpdateStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "hasRun", "Ljava/util/concurrent/atomic/AtomicBoolean;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scheduleImmediateUpdateCheck", "scheduleRepeatedUpdateCheck", "queueUpdateCheck", "core"})
@SourceDebugExtension(value={"SMAP\nCopilotUpdateStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopilotUpdateStartupActivity.kt\ncom/github/copilot/update/CopilotUpdateStartupActivity\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n8#2:63\n*S KotlinDebug\n*F\n+ 1 CopilotUpdateStartupActivity.kt\ncom/github/copilot/update/CopilotUpdateStartupActivity\n*L\n56#1:63\n*E\n"})
public final class CopilotUpdateStartupActivity
implements ProjectActivity {
    @NotNull
    private final AtomicBoolean hasRun = new AtomicBoolean(false);

    @RequiresBackgroundThread
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        this.scheduleImmediateUpdateCheck(project);
        this.scheduleRepeatedUpdateCheck();
        return Unit.INSTANCE;
    }

    private final void scheduleImmediateUpdateCheck(Project project) {
        if (!this.hasRun.compareAndSet(false, true) || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime lastCheck = CopilotLocalApplicationSettings.settings().lastUpdateCheck;
        if (lastCheck != null && lastCheck.plusDays(1L).isAfter(now)) {
            return;
        }
        CopilotLocalApplicationSettings.settings().lastUpdateCheck = now;
        this.queueUpdateCheck(project);
    }

    private final void scheduleRepeatedUpdateCheck() {
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> CopilotUpdateStartupActivity.scheduleRepeatedUpdateCheck$lambda$0(this), 24L, 24L, TimeUnit.HOURS);
    }

    private final void queueUpdateCheck(Project project) {
        if (!CopilotApplicationSettings.settings().checkForUpdate) {
            CopilotUpdateStartupActivity $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CopilotUpdateStartupActivity.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.debug("Update check is disabled");
            return;
        }
        new CopilotPluginUpdater.CheckUpdatesTask(project).queue();
    }

    private static final void scheduleRepeatedUpdateCheck$lambda$0(CopilotUpdateStartupActivity this$0) {
        Project project = ApplicationUtil.findCurrentProject();
        if (project != null) {
            this$0.queueUpdateCheck(project);
        }
    }
}

