/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnonymizeUtils {
    private static final String PROTOCOL_REGEX = "(file|notebook|sftp|ftp):/{2,4}";
    private static final String USER_INFO_REGEX = "([^/]+@)?";
    private static final String HOST_REGEX = "([^/]+)?";
    private static final String DRIVE_LETTER_REGEX = "([a-zA-Z](%3A|%3a|:)(\\\\\\\\|\\\\|/)|(\\\\\\\\|\\\\|/))?";
    private static final String PATH_SEGMENT_REGEX = "([\\w-._!#@$+ ]+(\\\\\\\\|\\\\|/))+";
    private static final String FILE_NAME_REGEX = "[\\w-._!#@$+ ]*";
    private static final String FILE_PATH_REGEX = "((file|notebook|sftp|ftp):/{2,4}([^/]+@)?([^/]+)?)?([a-zA-Z](%3A|%3a|:)(\\\\\\\\|\\\\|/)|(\\\\\\\\|\\\\|/))?([\\w-._!#@$+ ]+(\\\\\\\\|\\\\|/))+[\\w-._!#@$+ ]*";
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("((file|notebook|sftp|ftp):/{2,4}([^/]+@)?([^/]+)?)?([a-zA-Z](%3A|%3a|:)(\\\\\\\\|\\\\|/)|(\\\\\\\\|\\\\|/))?([\\w-._!#@$+ ]+(\\\\\\\\|\\\\|/))+[\\w-._!#@$+ ]*");
    private static final Pattern GOOGLE_API_KEY_PATTERN = Pattern.compile("AIza[a-zA-Z0-9_\\-]{35}");
    private static final Pattern SLACK_TOKEN_PATTERN = Pattern.compile("xox[pabers]-[a-zA-Z0-9]", 2);
    private static final Pattern GITHUB_TOKEN_PATTERN = Pattern.compile("(gh[psuro]_[a-zA-Z0-9]{36}|github_pat_[a-zA-Z0-9]{22}_[a-zA-Z0-9]{59})");
    private static final Pattern GENERIC_SECRET_PATTERN = Pattern.compile("(key|token|sig|secret|signature|password|passwd|pwd|android:value)[^a-zA-Z0-9]", 2);
    private static final Pattern CLI_CREDENTIALS_PATTERN = Pattern.compile("((login|psexec|(certutil|psexec)\\.exe).{1,50}(\\s-u(ser(name)?)?\\s+.{3,100})?\\s-(admin|user|vm|root)?p(ass(word)?)?\\s+[\"']?[^$\\-/\\s]|(^|[\\s\\r\\n\\\\])net(\\.exe)?.{1,5}(user\\s+|share\\s+/user:| user -? secrets ? set) \\s + [^ $\\s/])");
    private static final Pattern MSFT_ENTRA_ID_PATTERN = Pattern.compile("eyJ(?:0eXAiOiJKV1Qi|hbGci|[a-zA-Z0-9\\-_]+\\.[a-zA-Z0-9\\-_]+\\.[a-zA-Z0-9\\-_]*)");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-]+)");
    private static final Map<Pattern, String> PATTERN_MAP = new HashMap<Pattern, String>(){
        {
            this.put(GOOGLE_API_KEY_PATTERN, "<REDACTED: Google API Key>");
            this.put(SLACK_TOKEN_PATTERN, "<REDACTED: Slack Token>");
            this.put(GITHUB_TOKEN_PATTERN, "<REDACTED: GitHub Token>");
            this.put(GENERIC_SECRET_PATTERN, "<REDACTED: Generic Secret>");
            this.put(CLI_CREDENTIALS_PATTERN, "<REDACTED: CLI Credentials>");
            this.put(MSFT_ENTRA_ID_PATTERN, "<REDACTED: Microsoft Entra ID>");
            this.put(EMAIL_PATTERN, "<REDACTED: Email>");
        }
    };
    private static final Pattern CLS_NAME = Pattern.compile("^@github/copilot-language-server$");
    private static final List<Pattern> SKIP_PATTERNS = List.of(CLS_NAME);

    @NotNull
    public static Map<String, String> redactPii(@NotNull Map<String, String> properties) {
        ConcurrentHashMap<String, String> newProperties = new ConcurrentHashMap<String, String>();
        properties.forEach((key, value) -> {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                String sanitizedValue = AnonymizeUtils.redactPii(value);
                newProperties.put((String)key, sanitizedValue);
            } else {
                newProperties.put((String)key, (String)value);
            }
        });
        return newProperties;
    }

    public static String redactPii(@Nullable String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        return Arrays.stream(value.split("\\r?\\n")).map(AnonymizeUtils::anonymizePiiData).collect(Collectors.joining("\n"));
    }

    private static String anonymizePiiData(@Nullable String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        for (Pattern skipPattern : SKIP_PATTERNS) {
            if (!skipPattern.matcher(input).find()) continue;
            return input;
        }
        String result = FILE_PATH_PATTERN.matcher(input).replaceAll("<REDACTED: user-file-path>");
        for (Pattern pattern : PATTERN_MAP.keySet()) {
            if (!pattern.matcher(result).find()) continue;
            return PATTERN_MAP.get(pattern);
        }
        return result;
    }
}

