/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationUtil {
    private ApplicationUtil() {
    }

    @Nullable
    public static Project findCurrentProject() {
        Project project;
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project2 = project = frame != null ? frame.getProject() : null;
        if (ApplicationUtil.isValidProject(project)) {
            return project;
        }
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!ApplicationUtil.isValidProject(p)) continue;
            return p;
        }
        return null;
    }

    @Nonnull
    public static Iterable<Project> findValidProjects() {
        return Arrays.stream(ProjectManager.getInstance().getOpenProjects()).filter(ApplicationUtil::isValidProject).collect(Collectors.toList());
    }

    private static boolean isValidProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && !project.isDefault();
    }
}

