/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotApplicationState;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.accessibility.AccessibleAnnouncerUtil;
import com.jetbrains.JBR;
import javax.accessibility.Accessible;
import javax.swing.JFrame;

public final class CopilotScreenReaderUtil {
    private CopilotScreenReaderUtil() {
    }

    public static void announce(String str, boolean interruptCurrentOutput) {
        if (!CopilotScreenReaderUtil.isSafeAnnouncingAvailable()) {
            return;
        }
        JFrame frame = WindowManager.getInstance().findVisibleFrame();
        if (frame == null) {
            return;
        }
        AccessibleAnnouncerUtil.announce((Accessible)frame, (String)str, (boolean)interruptCurrentOutput);
    }

    public static boolean isAnnouncingAvailable() {
        CopilotApplicationState applicationSettings = CopilotApplicationSettings.settings();
        return applicationSettings != null && applicationSettings.isScreenReaderEnabled() && JBR.isAccessibleAnnouncerSupported();
    }

    public static boolean isSafeAnnouncingAvailable() {
        return SystemInfo.isMac && CopilotScreenReaderUtil.isAnnouncingAvailable();
    }
}

