/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import com.github.copilot.telemetry.TelemetryService;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.util.io.DigestUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Experiments {
    private Experiments() {
    }

    public static boolean chooseUser(@NotNull String experimentName, double chosenUserPercentage) {
        try {
            return Experiments.chooseUserWithID(PermanentInstallationID.get(), experimentName, chosenUserPercentage);
        }
        catch (Exception e) {
            TelemetryService.getInstance().track("editor.intellij.loginExperimentFailed", Map.of("error", e.getMessage()));
            return false;
        }
    }

    static boolean chooseUserWithID(@NotNull String userId, @NotNull String experimentName, double chosenUserPercentage) {
        String idWithSalt = userId + "-" + experimentName;
        MessageDigest md5Hash = DigestUtil.md5();
        md5Hash.update(idWithSalt.getBytes(StandardCharsets.UTF_8));
        String md5Hex = DigestUtil.digestToHash((MessageDigest)md5Hash);
        return (double)Integer.parseInt(md5Hex, 0, 6, 16) / 1.6777215E7 <= chosenUserPercentage;
    }
}

