/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileSizeUtil {
    @TestOnly
    public static final Key<Boolean> KEY_TOO_LARGE = Key.create((String)"copilot.fileTooLarge");
    public static final long MAX_FILE_SIZE = 0x100000L;

    private FileSizeUtil() {
    }

    public static boolean isSupported(@Nullable VirtualFile file) {
        return file != null && file.getLength() <= 0x100000L && !KEY_TOO_LARGE.isIn((UserDataHolder)file);
    }

    public static boolean isTooLarge(@NotNull VirtualFile file) {
        return file.getLength() > 0x100000L || KEY_TOO_LARGE.isIn((UserDataHolder)file);
    }
}

