/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import com.github.copilot.telemetry.ErrorReportService;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoggerUtil {
    public static final Consumer<Throwable> LogAsDebug = throwable -> Logger.getInstance(LoggerUtil.class).debug(throwable);
    private static final Pattern AuthorizationHeaderPattern = Pattern.compile("(\"Authorization\":\\s*\")([^\"]*)\"", 2);

    private LoggerUtil() {
    }

    public static String redactAuthorizationHeader(@NotNull String message) {
        return AuthorizationHeaderPattern.matcher(message).replaceAll("$1[REDACTED]\"");
    }

    public static void errorAndSecureTelemetry(@NotNull Logger logger, @NotNull String message, @Nullable Throwable original, Attachment ... attachments) {
        logger.error(message, original, attachments);
        LoggerUtil.reportToSecureTelemetry(message, original);
    }

    private static void reportToSecureTelemetry(@NotNull String message, @Nullable Throwable original) {
        Throwable reportedException = original != null ? original : new RuntimeException("Plugin error report: " + message);
        Map<String, String> properties = LoggerUtil.createProperties(message);
        ErrorReportService.getInstance().reportException(reportedException, properties, 0);
    }

    @NotNull
    private static Map<String, String> createProperties(@NotNull String message) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("errorType", "errorAndSecureTelemetry");
        properties.put("message", message);
        return properties;
    }
}

