/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Maps {
    private Maps() {
    }

    @SafeVarargs
    public static <K, V> Map<K, V> merge(Map<K, ? extends V> ... maps) {
        if (maps.length == 0) {
            return Collections.emptyMap();
        }
        if (maps.length == 1) {
            return Map.copyOf(maps[0]);
        }
        HashMap<K, V> all = null;
        for (Map<K, V> map : maps) {
            if (map.isEmpty()) continue;
            if (all == null) {
                all = new HashMap<K, V>();
            }
            all.putAll(map);
        }
        return all == null ? Collections.emptyMap() : Collections.unmodifiableMap(all);
    }
}

