/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.util;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class ProcessUtil {
    private static final Logger LOG = Logger.getInstance(ProcessUtil.class);

    public static void waitForProcessTermination(@NotNull KillableProcessHandler process, @NotNull Duration duration, @NotNull Duration interval) {
        long startTime = System.currentTimeMillis();
        LOG.debug(String.format("Waiting for process termination (max %s, interval %s)", duration, interval));
        while (true) {
            if (process.isProcessTerminated()) {
                LOG.debug("Process terminated");
                break;
            }
            if (System.currentTimeMillis() - startTime > duration.toMillis()) {
                LOG.warn("Process did not terminate in time, destroying it");
                process.destroyProcess();
                break;
            }
            try {
                Thread.sleep(interval.toMillis());
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted when waiting for process to terminate", (Throwable)e);
                break;
            }
        }
    }
}

