/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.teamsys.dnq.database;

import com.jetbrains.teamsys.dnq.database.EntityMetaDataUtils;
import com.jetbrains.teamsys.dnq.database.ValidationUtil;
import com.jetbrains.teamsys.dnq.database.ValidationUtil$WhenMappings;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.query.metadata.AssociationEndCardinality;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.exodus.query.metadata.PropertyMetaData;
import jetbrains.exodus.query.metadata.PropertyType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.NamedKLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\rJ\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\rJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0003J\u0016\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018H\u0003J\u001d\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001d\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/teamsys/dnq/database/ValidationUtil;", "", "()V", "logger", "Lmu/KLogger;", "checkCardinality", "", "entity", "Ljetbrains/exodus/entitystore/Entity;", "cardinality", "Ljetbrains/exodus/query/metadata/AssociationEndCardinality;", "associationName", "", "checkCardinality$dnq_transient_store", "e", "md", "Ljetbrains/exodus/query/metadata/AssociationEndMetaData;", "checkProperty", "", "emd", "Ljetbrains/exodus/query/metadata/EntityMetaData;", "name", "isEmptyPrimitiveProperty", "propertyValue", "", "validateAssociations", "modelMetaData", "Ljetbrains/exodus/query/metadata/ModelMetaData;", "validateAssociations$dnq_transient_store", "validateEntity", "validateRequiredProperties", "validateRequiredProperties$dnq_transient_store", "dnq-transient-store"})
public final class ValidationUtil {
    private static final KLogger logger;
    @NotNull
    public static final ValidationUtil INSTANCE;

    @JvmStatic
    public static final void validateEntity(@NotNull Entity entity, @NotNull ModelMetaData modelMetaData) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)modelMetaData, (String)"modelMetaData");
        ValidationUtil.validateAssociations$dnq_transient_store(entity, modelMetaData);
        ValidationUtil.validateRequiredProperties$dnq_transient_store(entity, modelMetaData);
    }

    @JvmStatic
    public static final void validateAssociations$dnq_transient_store(@NotNull Entity entity, @NotNull ModelMetaData modelMetaData) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)modelMetaData, (String)"modelMetaData");
        EntityMetaData entityMetaData = modelMetaData.getEntityMetaData(entity.getType());
        Object object = entityMetaData;
        if (object != null && (object = object.getAssociationEndsMetaData()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AssociationEndMetaData associationEndMetaData = (AssociationEndMetaData)element$iv;
                boolean bl = false;
                logger.trace((Function0)new Function0<Object>(associationEndMetaData, entity){
                    final /* synthetic */ AssociationEndMetaData $associationEndMetaData;
                    final /* synthetic */ Entity $entity$inlined;
                    {
                        this.$associationEndMetaData = associationEndMetaData;
                        this.$entity$inlined = entity;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Validate cardinality [").append(this.$entity$inlined.getType()).append('.');
                        AssociationEndMetaData associationEndMetaData = this.$associationEndMetaData;
                        Intrinsics.checkExpressionValueIsNotNull((Object)associationEndMetaData, (String)"associationEndMetaData");
                        StringBuilder stringBuilder2 = stringBuilder.append(associationEndMetaData.getName()).append("]. Required is [");
                        AssociationEndMetaData associationEndMetaData2 = this.$associationEndMetaData;
                        Intrinsics.checkExpressionValueIsNotNull((Object)associationEndMetaData2, (String)"associationEndMetaData");
                        return stringBuilder2.append(associationEndMetaData2.getCardinality().getName()).append(']').toString();
                    }
                });
                AssociationEndMetaData associationEndMetaData2 = associationEndMetaData;
                Intrinsics.checkExpressionValueIsNotNull((Object)associationEndMetaData2, (String)"associationEndMetaData");
                if (ValidationUtil.checkCardinality$dnq_transient_store(entity, associationEndMetaData2)) continue;
                logger.error((Function0)new Function0<Object>(associationEndMetaData, entity){
                    final /* synthetic */ AssociationEndMetaData $associationEndMetaData;
                    final /* synthetic */ Entity $entity$inlined;
                    {
                        this.$associationEndMetaData = associationEndMetaData;
                        this.$entity$inlined = entity;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Validation: Cardinality violation for [").append(this.$entity$inlined).append('.');
                        AssociationEndMetaData associationEndMetaData = this.$associationEndMetaData;
                        Intrinsics.checkExpressionValueIsNotNull((Object)associationEndMetaData, (String)"associationEndMetaData");
                        StringBuilder stringBuilder2 = stringBuilder.append(associationEndMetaData.getName()).append("]. Required cardinality is [");
                        AssociationEndMetaData associationEndMetaData2 = this.$associationEndMetaData;
                        Intrinsics.checkExpressionValueIsNotNull((Object)associationEndMetaData2, (String)"associationEndMetaData");
                        return stringBuilder2.append(associationEndMetaData2.getCardinality().getName()).append(']').toString();
                    }
                });
            }
        }
    }

    @JvmStatic
    public static final boolean checkCardinality$dnq_transient_store(@NotNull Entity e, @NotNull AssociationEndMetaData md) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)md, (String)"md");
        AssociationEndCardinality associationEndCardinality = md.getCardinality();
        Intrinsics.checkExpressionValueIsNotNull((Object)associationEndCardinality, (String)"md.cardinality");
        String string = md.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"md.name");
        return ValidationUtil.checkCardinality$dnq_transient_store(e, associationEndCardinality, string);
    }

    @JvmStatic
    public static final boolean checkCardinality$dnq_transient_store(@NotNull Entity entity, @NotNull AssociationEndCardinality cardinality, @NotNull String associationName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)cardinality, (String)"cardinality");
        Intrinsics.checkParameterIsNotNull((Object)associationName, (String)"associationName");
        int size2 = 0;
        EntityIterator entityIterator = entity.getLinks(associationName).iterator();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterator, (String)"entity.getLinks(associationName).iterator()");
        EntityIterator it = entityIterator;
        while (it.hasNext()) {
            Entity e = (Entity)it.next();
            if (e != null) {
                ++size2;
                continue;
            }
            logger.error((Function0)new Function0<Object>(entity, associationName){
                final /* synthetic */ Entity $entity;
                final /* synthetic */ String $associationName;

                @Nullable
                public final Object invoke() {
                    return "Validation: Null entity in the [" + this.$entity + '.' + this.$associationName + ']';
                }
                {
                    this.$entity = entity;
                    this.$associationName = string;
                    super(0);
                }
            });
        }
        switch (ValidationUtil$WhenMappings.$EnumSwitchMapping$0[cardinality.ordinal()]) {
            case 1: {
                if (size2 <= 1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                if (size2 == 1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if (size2 >= 1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @JvmStatic
    public static final void validateRequiredProperties$dnq_transient_store(@NotNull Entity entity, @NotNull ModelMetaData modelMetaData) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)modelMetaData, (String)"modelMetaData");
        EntityMetaData entityMetaData = modelMetaData.getEntityMetaData(entity.getType());
        if (entityMetaData != null) {
            String it;
            Set set = entityMetaData.getRequiredProperties();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"entityMetaData.requiredProperties");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                ValidationUtil.checkProperty(entity, entityMetaData, string);
            }
            $this$forEach$iv = EntityMetaDataUtils.getRequiredIfProperties(entityMetaData, entity);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                ValidationUtil.checkProperty(entity, entityMetaData, it);
            }
        }
    }

    @JvmStatic
    private static final void checkProperty(Entity e, EntityMetaData emd, String name) {
        boolean bl;
        PropertyType propertyType;
        PropertyMetaData pmd = emd.getPropertyMetaData(name);
        if (pmd != null) {
            propertyType = pmd.getType();
        } else {
            logger.warn((Function0)checkProperty.type.1.INSTANCE);
            propertyType = PropertyType.PRIMITIVE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyType, (String)"if (pmd != null) {\n     \u2026yType.PRIMITIVE\n        }");
        PropertyType type2 = propertyType;
        switch (ValidationUtil$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
            case 1: {
                bl = ValidationUtil.isEmptyPrimitiveProperty(e.getProperty(name));
                break;
            }
            case 2: {
                if (e.getBlob(name) == null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = ValidationUtil.isEmptyPrimitiveProperty((Comparable)((Object)e.getBlobString(name)));
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown property type: " + name);
            }
        }
        boolean isEmpty = bl;
        if (isEmpty) {
            logger.error((Function0)new Function0<Object>(e, name){
                final /* synthetic */ Entity $e;
                final /* synthetic */ String $name;

                @Nullable
                public final Object invoke() {
                    return "Validation: Property [" + this.$e + '.' + this.$name + "] is empty.";
                }
                {
                    this.$e = entity;
                    this.$name = string;
                    super(0);
                }
            });
        }
    }

    @JvmStatic
    private static final boolean isEmptyPrimitiveProperty(Comparable<?> propertyValue) {
        return propertyValue == null || Intrinsics.areEqual(propertyValue, (Object)"");
    }

    private ValidationUtil() {
    }

    static {
        ValidationUtil validationUtil;
        INSTANCE = validationUtil = new ValidationUtil();
        String string = ValidationUtil.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ValidationUtil::class.java.name");
        logger = new NamedKLogging(string).getLogger();
    }
}

