/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl;
import com.jetbrains.teamsys.dnq.database.TransientSessionImpl;
import java.util.Set;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.database.ListenerInvocationTransport;
import jetbrains.exodus.database.TransientChangesTracker;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.entitystore.TransientChangesMultiplexer;
import jetbrains.exodus.entitystore.TransientChangesMultiplexerJob;
import jetbrains.exodus.entitystore.Where;
import jetbrains.exodus.entitystore.listeners.AsyncListenersReplicationImpl;
import jetbrains.exodus.entitystore.listeners.ListenerInvocationsImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.io.DataReaderWriterProvider;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/entitystore/TransientChangesMultiplexerJob;", "Ljetbrains/exodus/core/execution/Job;", "store", "Ljetbrains/exodus/database/TransientEntityStore;", "transientChangesMultiplexer", "Ljetbrains/exodus/entitystore/TransientChangesMultiplexer;", "changes", "", "Ljetbrains/exodus/database/TransientEntityChange;", "changesTracker", "Ljetbrains/exodus/database/TransientChangesTracker;", "(Ljetbrains/exodus/database/TransientEntityStore;Ljetbrains/exodus/entitystore/TransientChangesMultiplexer;Ljava/util/Set;Ljetbrains/exodus/database/TransientChangesTracker;)V", "execute", "", "getGroup", "", "Lorg/jetbrains/annotations/NotNull;", "getName", "dnq-transient-store"})
public final class TransientChangesMultiplexerJob
extends Job {
    private final TransientEntityStore store;
    private final TransientChangesMultiplexer transientChangesMultiplexer;
    private final Set<TransientEntityChange> changes;
    private final TransientChangesTracker changesTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            Long currentAddress2;
            TransientEntityStoreImpl transientEntityStoreImpl;
            TransientEntityStore transientEntityStore = this.store;
            if (transientEntityStore == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl");
            }
            TransientEntityStoreImpl $this$run = transientEntityStoreImpl = (TransientEntityStoreImpl)transientEntityStore;
            boolean bl = false;
            Environment environment = $this$run.getPersistentStore().getEnvironment();
            if (environment == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.env.EnvironmentImpl");
            }
            DataReaderWriterProvider dataReaderWriterProvider = ((EnvironmentImpl)environment).getLog().getConfig().getReaderWriterProvider();
            boolean isPrimary = dataReaderWriterProvider == null || !dataReaderWriterProvider.isReadonly();
            long snapshotAddress = this.changesTracker.getSnapshot().getHighAddress();
            Long l = currentAddress2 = (Long)$this$run.getPersistentStore().computeInReadonlyTransaction((StoreTransactionalComputable)execute.1.currentAddress.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"currentAddress");
            TransientSessionImpl txn = new TransientSessionImpl($this$run, true, snapshotAddress, l);
            $this$run.registerStoreSession(txn);
            try {
                TransientChangesMultiplexer transientChangesMultiplexer;
                TransientChangesMultiplexer $this$run2 = transientChangesMultiplexer = this.transientChangesMultiplexer;
                boolean bl2 = false;
                ListenerInvocationsImpl invocations = null;
                ListenerInvocationTransport transport = ((TransientEntityStoreImpl)this.store).getInvocationTransport();
                if (isPrimary && transport != null) {
                    AsyncListenersReplicationImpl asyncListenersReplicationImpl = $this$run2.getAsyncListenersReplication();
                    invocations = asyncListenersReplicationImpl != null ? asyncListenersReplicationImpl.newInvocations(transport, snapshotAddress, currentAddress2) : null;
                }
                $this$run2.fire$dnq_transient_store(this.store, Where.ASYNC_AFTER_FLUSH, this.changes, invocations);
            }
            finally {
                txn.abort();
            }
        }
        finally {
            this.changesTracker.dispose();
        }
    }

    @NotNull
    public String getName() {
        return "Async events from EventMultiplexer";
    }

    @NotNull
    public String getGroup() {
        String string = this.store.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"store.location");
        return string;
    }

    public TransientChangesMultiplexerJob(@NotNull TransientEntityStore store, @NotNull TransientChangesMultiplexer transientChangesMultiplexer, @NotNull Set<TransientEntityChange> changes, @NotNull TransientChangesTracker changesTracker) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)transientChangesMultiplexer, (String)"transientChangesMultiplexer");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)changesTracker, (String)"changesTracker");
        this.store = store;
        this.transientChangesMultiplexer = transientChangesMultiplexer;
        this.changes = changes;
        this.changesTracker = changesTracker;
    }
}

