/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.database.DNQListener;
import jetbrains.exodus.database.EntityChangeType;
import jetbrains.exodus.database.IEntityListener;
import jetbrains.exodus.database.ListenerInvocation;
import jetbrains.exodus.database.ListenerInvocationTransport;
import jetbrains.exodus.database.ListenerInvocations;
import jetbrains.exodus.database.ListenerInvocationsBatch;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.listeners.AsyncListenersReplicationImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/entitystore/listeners/ListenerInvocationsImpl;", "Ljetbrains/exodus/database/ListenerInvocations;", "replication", "Ljetbrains/exodus/entitystore/listeners/AsyncListenersReplicationImpl;", "transport", "Ljetbrains/exodus/database/ListenerInvocationTransport;", "startHighAddress", "", "endHighAddress", "(Ljetbrains/exodus/entitystore/listeners/AsyncListenersReplicationImpl;Ljetbrains/exodus/database/ListenerInvocationTransport;JJ)V", "invocations", "", "Ljetbrains/exodus/database/ListenerInvocation;", "addInvocation", "", "change", "Ljetbrains/exodus/database/TransientEntityChange;", "listener", "Ljetbrains/exodus/database/IEntityListener;", "send", "dnq-transient-store"})
public final class ListenerInvocationsImpl
implements ListenerInvocations {
    private final List<ListenerInvocation> invocations;
    private final AsyncListenersReplicationImpl replication;
    private final ListenerInvocationTransport transport;
    private final long startHighAddress;
    private final long endHighAddress;

    public void addInvocation(@NotNull TransientEntityChange change, @NotNull IEntityListener<?> listener) {
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        if (!this.replication.shouldReplicate(change, listener)) {
            return;
        }
        EntityId entityId = change.getTransientEntity().getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"change.transientEntity.id");
        EntityId entityId2 = entityId;
        String string = this.replication.getListenersSerialization().getKey((DNQListener)listener);
        EntityId entityId3 = entityId2;
        EntityChangeType entityChangeType = change.getChangeType();
        this.invocations.add(new ListenerInvocation(string, entityChangeType, entityId3));
    }

    public void send() {
        Collection collection = this.invocations;
        if (!collection.isEmpty()) {
            ListenerInvocationsBatch batch = new ListenerInvocationsBatch(this.startHighAddress, this.endHighAddress, this.invocations);
            this.transport.send(batch);
        }
    }

    public ListenerInvocationsImpl(@NotNull AsyncListenersReplicationImpl replication, @NotNull ListenerInvocationTransport transport, long startHighAddress, long endHighAddress) {
        Intrinsics.checkParameterIsNotNull((Object)replication, (String)"replication");
        Intrinsics.checkParameterIsNotNull((Object)transport, (String)"transport");
        this.replication = replication;
        this.transport = transport;
        this.startHighAddress = startHighAddress;
        this.endHighAddress = endHighAddress;
        this.invocations = new ArrayList();
    }
}

