/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.Selector;
import jetbrains.exodus.query.InMemoryQueueSortIterableMixin;
import jetbrains.exodus.query.PriorityMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/query/InMemoryHeapSortIterableWithValueGetter;", "Ljetbrains/exodus/query/InMemoryQueueSortIterableMixin;", "source", "", "Ljetbrains/exodus/entitystore/Entity;", "valueGetter", "Ljetbrains/exodus/entitystore/ComparableGetter;", "valueComparator", "Ljava/util/Comparator;", "", "", "(Ljava/lang/Iterable;Ljetbrains/exodus/entitystore/ComparableGetter;Ljava/util/Comparator;)V", "getSource", "()Ljava/lang/Iterable;", "createQueue", "Ljava/util/Queue;", "unsorted", "", "xodus-query"})
public final class InMemoryHeapSortIterableWithValueGetter
implements InMemoryQueueSortIterableMixin {
    @NotNull
    private final Iterable<Entity> source;
    @NotNull
    private final ComparableGetter valueGetter;
    @NotNull
    private final Comparator<Comparable<Object>> valueComparator;

    public InMemoryHeapSortIterableWithValueGetter(@NotNull Iterable<? extends Entity> source, @NotNull ComparableGetter valueGetter, @NotNull Comparator<Comparable<Object>> valueComparator) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)valueGetter, (String)"valueGetter");
        Intrinsics.checkNotNullParameter(valueComparator, (String)"valueComparator");
        this.source = source;
        this.valueGetter = valueGetter;
        this.valueComparator = valueComparator;
    }

    @Override
    @NotNull
    public Iterable<Entity> getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Queue<Entity> createQueue(@NotNull Collection<? extends Entity> unsorted) {
        Intrinsics.checkNotNullParameter(unsorted, (String)"unsorted");
        PriorityMap<Entity> result = new PriorityMap<Entity>(unsorted.size(), this.valueComparator, (Selector)this.valueGetter);
        Iterable $this$forEach$iv = unsorted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            result.offer(it);
        }
        return result;
    }

    @Override
    @NotNull
    public Iterator<Entity> iterator() {
        return InMemoryQueueSortIterableMixin.DefaultImpls.iterator(this);
    }
}

