/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.SortEngine;
import org.jetbrains.annotations.NotNull;

public class InMemoryMergeSortOnInitIterable
extends SortEngine.InMemorySortIterable {
    public InMemoryMergeSortOnInitIterable(@NotNull Iterable<Entity> source, @NotNull Comparator<Entity> comparator) {
        super(source, comparator);
    }

    @Override
    @NotNull
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private List<Entity>[] src;
            private int current;

            @Override
            public boolean hasNext() {
                if (this.src == null) {
                    this.init();
                }
                return this.current < this.src[0].size();
            }

            @Override
            public Entity next() {
                if (this.src == null) {
                    this.init();
                }
                if (this.current >= this.src[0].size()) {
                    throw new NoSuchElementException();
                }
                return this.src[0].get(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void init() {
                this.src = new ArrayList[]{new ArrayList(), null};
                for (Entity entity : InMemoryMergeSortOnInitIterable.this.getSrc()) {
                    this.src[0].add(entity);
                }
                this.src[1] = new ArrayList<Entity>(this.src[0]);
                this.msort(0, this.src[0].size() - 1, 0);
            }

            public void msort(int left, int right, int c) {
                if (left >= right) {
                    for (int i = left; i <= right; ++i) {
                        this.src[c].set(i, this.src[1 - c].get(i));
                    }
                    return;
                }
                int rStart = (left + right + 1) / 2;
                this.msort(left, rStart - 1, 1 - c);
                this.msort(rStart, right, 1 - c);
                int i = left;
                int j = rStart;
                Comparator<Entity> comparator = InMemoryMergeSortOnInitIterable.this.getComparator();
                for (int k = left; k <= right; ++k) {
                    if (j > right || i < rStart && comparator.compare(this.src[1 - c].get(i), this.src[1 - c].get(j)) <= 0) {
                        this.src[c].set(k, this.src[1 - c].get(i++));
                        continue;
                    }
                    this.src[c].set(k, this.src[1 - c].get(j++));
                }
            }
        };
    }
}

