/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.SortEngine;
import org.jetbrains.annotations.NotNull;

public class InMemoryQuickSortIterable
extends SortEngine.InMemorySortIterable {
    public InMemoryQuickSortIterable(@NotNull Iterable<Entity> source, @NotNull Comparator<Entity> comparator) {
        super(source, comparator);
    }

    @Override
    @NotNull
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private List<Entity> src;
            private List<Integer> left;
            private List<Integer> right;
            private List<Integer> medianStart;
            private List<Integer> medianEnd;
            private List<Entity> medians;
            private List<Entity> toRight;
            private int top;
            private int current;

            @Override
            public boolean hasNext() {
                if (this.src == null) {
                    this.init();
                }
                return this.current < this.src.size();
            }

            @Override
            public Entity next() {
                if (this.src == null) {
                    this.init();
                }
                if (this.current >= this.src.size()) {
                    throw new NoSuchElementException();
                }
                while (this.top >= 0 && this.right.get(this.top) < this.current) {
                    this.left.remove(this.top);
                    this.right.remove(this.top);
                    this.medianStart.remove(this.top);
                    this.medianEnd.remove(this.top);
                    --this.top;
                }
                if (this.top < 0 || this.current > this.medianEnd.get(this.top)) {
                    Comparator<Entity> comparator = InMemoryQuickSortIterable.this.getComparator();
                    do {
                        int r;
                        int l;
                        if (this.top < 0) {
                            l = 0;
                            r = this.src.size() - 1;
                        } else if (this.current == this.left.get(this.top)) {
                            l = this.left.get(this.top);
                            r = this.medianStart.get(this.top) - 1;
                        } else {
                            l = this.medianEnd.get(this.top) + 1;
                            r = this.right.get(this.top);
                        }
                        Entity median = this.src.get((l + r) / 2);
                        int i = l;
                        this.medians.clear();
                        this.toRight.clear();
                        while (true) {
                            if (i <= r && comparator.compare(this.src.get(i), median) < 0) {
                                if (this.toRight.size() + this.medians.size() > 0) {
                                    this.src.set(i - this.toRight.size() - this.medians.size(), this.src.get(i));
                                }
                                ++i;
                                continue;
                            }
                            if (i <= r) {
                                Entity entity = this.src.get(i);
                                if (comparator.compare(entity, median) == 0) {
                                    this.medians.add(entity);
                                } else {
                                    this.toRight.add(entity);
                                }
                                ++i;
                            }
                            if (i > r) break;
                        }
                        int current = i - this.toRight.size() - this.medians.size();
                        for (Entity e : this.medians) {
                            this.src.set(current++, e);
                        }
                        for (Entity e : this.toRight) {
                            this.src.set(current++, e);
                        }
                        this.left.add(l);
                        this.right.add(r);
                        this.medianStart.add(r + 1 - this.toRight.size() - this.medians.size());
                        this.medianEnd.add(r - this.toRight.size());
                        ++this.top;
                    } while (this.current < this.medianStart.get(this.top));
                }
                return this.src.get(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void init() {
                this.src = new ArrayList<Entity>();
                for (Entity it : InMemoryQuickSortIterable.this.getSrc()) {
                    this.src.add(it);
                }
                this.left = new ArrayList<Integer>();
                this.right = new ArrayList<Integer>();
                this.medianStart = new ArrayList<Integer>();
                this.medianEnd = new ArrayList<Integer>();
                this.medians = new ArrayList<Entity>();
                this.toRight = new ArrayList<Entity>();
                this.top = -1;
            }
        };
    }
}

