/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;

public class LinkEqual
extends NodeBase {
    private final String name;
    private final EntityId id;

    public LinkEqual(String name, Entity to) {
        this(name, to == null ? null : to.getId());
    }

    private LinkEqual(String name, EntityId id) {
        this.name = name;
        this.id = id;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData, NodeBase.InstantiateContext context) {
        if (this.id instanceof PersistentEntityId) {
            queryEngine.assertOperational();
            PersistentEntityStoreImpl store = queryEngine.getPersistentStore();
            return store.getAndCheckCurrentTransaction().findLinks(entityType, (Entity)new PersistentEntity(store, (PersistentEntityId)this.id), this.name);
        }
        return EntityIterableBase.EMPTY;
    }

    @Override
    public NodeBase getClone() {
        return new LinkEqual(this.name, this.id);
    }

    public String getName() {
        return this.name;
    }

    public EntityId getToId() {
        return this.id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof LinkEqual)) {
            return false;
        }
        LinkEqual linkEqual = (LinkEqual)obj;
        return Utils.safe_equals(this.name, linkEqual.name) && Utils.safe_equals(this.id, linkEqual.id);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.name + '=' + this.id + ") ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        StringBuilder result = super.getHandle(sb).append('(').append(this.name).append('=');
        if (this.id != null) {
            if (this.id instanceof PersistentEntityId) {
                ((PersistentEntityId)this.id).toString(result);
            } else {
                result.append(this.id);
            }
        }
        return result.append(')');
    }

    @Override
    public String getSimpleName() {
        return "le";
    }
}

