/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;

public class LinkNotNull
extends NodeBase {
    private final String name;

    public LinkNotNull(String name) {
        this.name = name;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData, NodeBase.InstantiateContext context) {
        queryEngine.assertOperational();
        PersistentStoreTransaction txn = queryEngine.getPersistentStore().getAndCheckCurrentTransaction();
        return txn.findWithLinks(entityType, this.name);
    }

    @Override
    public NodeBase getClone() {
        return new LinkNotNull(this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof LinkNotNull)) {
            return false;
        }
        LinkNotNull linkNotNull = (LinkNotNull)obj;
        return Utils.safe_equals(this.name, linkNotNull.name);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.name + "!=null) ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        return super.getHandle(sb).append('(').append(this.name).append(')');
    }

    @Override
    public String getSimpleName() {
        return "lnn";
    }
}

