/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Collection;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinkNotNull;
import jetbrains.exodus.query.Minus;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyNotNull;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\u0018\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0016\u001a\u00060\u0014j\u0002`\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0004J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0014R\u001a\u0010\u0004\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006+"}, d2={"Ljetbrains/exodus/query/LinksEqualDecorator;", "Ljetbrains/exodus/query/NodeBase;", "linkName", "", "decorated", "linkEntityType", "(Ljava/lang/String;Ljetbrains/exodus/query/NodeBase;Ljava/lang/String;)V", "getDecorated", "()Ljetbrains/exodus/query/NodeBase;", "setDecorated", "(Ljetbrains/exodus/query/NodeBase;)V", "getLinkEntityType", "()Ljava/lang/String;", "getLinkName", "equals", "", "other", "", "getClone", "getHandle", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "getSimpleName", "instantiate", "", "Ljetbrains/exodus/entitystore/Entity;", "entityType", "queryEngine", "Ljetbrains/exodus/query/QueryEngine;", "metaData", "Ljetbrains/exodus/query/metadata/ModelMetaData;", "context", "Ljetbrains/exodus/query/NodeBase$InstantiateContext;", "instantiateDecorated", "optimize", "", "sorts", "Ljetbrains/exodus/query/Sorts;", "rules", "Ljetbrains/exodus/query/OptimizationPlan;", "toString", "prefix", "xodus-query"})
public final class LinksEqualDecorator
extends NodeBase {
    @NotNull
    private final String linkName;
    @NotNull
    private NodeBase decorated;
    @NotNull
    private final String linkEntityType;

    public LinksEqualDecorator(@NotNull String linkName, @NotNull NodeBase decorated, @NotNull String linkEntityType) {
        Intrinsics.checkNotNullParameter((Object)linkName, (String)"linkName");
        Intrinsics.checkNotNullParameter((Object)decorated, (String)"decorated");
        Intrinsics.checkNotNullParameter((Object)linkEntityType, (String)"linkEntityType");
        this.linkName = linkName;
        this.decorated = decorated;
        this.linkEntityType = linkEntityType;
    }

    @NotNull
    public final String getLinkName() {
        return this.linkName;
    }

    @NotNull
    public final NodeBase getDecorated() {
        return this.decorated;
    }

    public final void setDecorated(@NotNull NodeBase nodeBase) {
        Intrinsics.checkNotNullParameter((Object)nodeBase, (String)"<set-?>");
        this.decorated = nodeBase;
    }

    @NotNull
    public final String getLinkEntityType() {
        return this.linkEntityType;
    }

    @Override
    @NotNull
    public Iterable<Entity> instantiate(@NotNull String entityType, @NotNull QueryEngine queryEngine, @NotNull ModelMetaData metaData, @NotNull NodeBase.InstantiateContext context) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)((Object)queryEngine), (String)"queryEngine");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        queryEngine.assertOperational();
        EntityIterable entityIterable = ((EntityIterableBase)queryEngine.instantiateGetAll(entityType)).findLinks(this.instantiateDecorated(this.linkEntityType, queryEngine, metaData, context), this.linkName);
        Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"queryEngine.instantiateG\u2026Data, context), linkName)");
        return (Iterable)entityIterable;
    }

    @Override
    @NotNull
    public NodeBase getClone() {
        NodeBase nodeBase = this.decorated.getClone();
        Intrinsics.checkNotNullExpressionValue((Object)nodeBase, (String)"decorated.clone");
        return new LinksEqualDecorator(this.linkName, nodeBase, this.linkEntityType);
    }

    @NotNull
    protected final Iterable<Entity> instantiateDecorated(@NotNull String entityType, @NotNull QueryEngine queryEngine, @Nullable ModelMetaData metaData, @NotNull NodeBase.InstantiateContext context) {
        EntityMetaData emd;
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)((Object)queryEngine), (String)"queryEngine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModelMetaData modelMetaData = metaData;
        EntityMetaData entityMetaData = emd = modelMetaData == null ? null : modelMetaData.getEntityMetaData(entityType);
        Iterable<Entity> result = (entityMetaData == null ? false : entityMetaData.isAbstract()) ? (Iterable<Entity>)EntityIterableBase.EMPTY : this.decorated.instantiate(entityType, queryEngine, metaData, context);
        EntityMetaData entityMetaData2 = emd;
        Collection collection = entityMetaData2 == null ? null : entityMetaData2.getSubTypes();
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        for (String subType : collection) {
            Iterable<Entity> iterable = result;
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"result");
            Intrinsics.checkNotNullExpressionValue((Object)subType, (String)"subType");
            result = queryEngine.unionAdjusted(iterable, this.instantiateDecorated(subType, queryEngine, metaData, context));
        }
        Iterable<Entity> iterable = result;
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"result");
        return iterable;
    }

    @Override
    public void optimize(@NotNull Sorts sorts, @NotNull OptimizationPlan rules) {
        PropertyEqual propEqual;
        Intrinsics.checkNotNullParameter((Object)sorts, (String)"sorts");
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        if (this.decorated instanceof LinkEqual) {
            LinkEqual linkEqual = (LinkEqual)this.decorated;
            if (linkEqual.getToId() == null) {
                this.decorated = new Minus(NodeFactory.all(), new LinkNotNull(linkEqual.getName()));
            }
        } else if (this.decorated instanceof PropertyEqual && (propEqual = (PropertyEqual)this.decorated).getValue() == null) {
            this.decorated = new Minus(NodeFactory.all(), new PropertyNotNull(propEqual.getName()));
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        this.checkWildcard(other);
        if (!(other instanceof LinksEqualDecorator)) {
            return false;
        }
        Object decorator = other;
        return !Utils.safe_equals(this.linkName, ((LinksEqualDecorator)decorator).linkName) || !Utils.safe_equals(this.linkEntityType, ((LinksEqualDecorator)decorator).linkEntityType) ? false : Utils.safe_equals(this.decorated, ((LinksEqualDecorator)decorator).decorated);
    }

    @Override
    @NotNull
    protected String toString(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return StringsKt.trimIndent((String)("\n            " + super.toString(prefix) + "\n            " + this.decorated.toString(Intrinsics.stringPlus((String)"  ", (Object)prefix)) + "\n            "));
    }

    @Override
    @NotNull
    public StringBuilder getHandle(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        super.getHandle(sb).append('(').append(this.linkName).append(',').append(this.linkEntityType).append(')').append('{');
        StringBuilder stringBuilder = this.decorated.getHandle(sb).append('}');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"decorated.getHandle(sb).append('}')");
        return stringBuilder;
    }

    @Override
    @NotNull
    public String getSimpleName() {
        return "led";
    }
}

