/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;

public class PropertyContains
extends NodeBase {
    private final String name;
    private final String contains;
    private final boolean ignoreCase;

    public PropertyContains(String name, String contains, boolean ignoreCase) {
        this.name = name;
        this.contains = contains;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData, NodeBase.InstantiateContext context) {
        queryEngine.assertOperational();
        return queryEngine.getPersistentStore().getAndCheckCurrentTransaction().findContaining(entityType, this.name, this.contains, this.ignoreCase);
    }

    @Override
    public NodeBase getClone() {
        return new PropertyContains(this.name, this.contains, this.ignoreCase);
    }

    @Override
    public void optimize(Sorts sorts, OptimizationPlan rules) {
        if (this.contains == null || this.contains.length() == 0) {
            NodeBase parent = this.getParent();
            parent.replaceChild(this, NodeFactory.all());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof PropertyContains)) {
            return false;
        }
        PropertyContains right = (PropertyContains)obj;
        return Utils.safe_equals(this.name, right.name) && Utils.safe_equals(this.contains, right.contains) && this.ignoreCase == right.ignoreCase;
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.name + ' ' + this.contains + ") ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        return super.getHandle(sb).append('(').append(this.name).append(' ').append(this.contains).append(')');
    }

    @Override
    public String getSimpleName() {
        return "pc";
    }
}

