/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;
import org.jetbrains.annotations.Nullable;

public class PropertyEqual
extends NodeBase {
    private final String name;
    @Nullable
    private final Comparable value;

    public PropertyEqual(String name, @Nullable Comparable value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Comparable getValue() {
        return this.value;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData, NodeBase.InstantiateContext context) {
        queryEngine.assertOperational();
        return queryEngine.getPersistentStore().getAndCheckCurrentTransaction().find(entityType, this.name, this.value);
    }

    @Override
    public NodeBase getClone() {
        return new PropertyEqual(this.name, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof PropertyEqual)) {
            return false;
        }
        PropertyEqual propertyEqual = (PropertyEqual)obj;
        return Utils.safe_equals(this.name, propertyEqual.name) && Utils.safe_equals(this.value, propertyEqual.value);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.name + '=' + this.value + ") ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        return super.getHandle(sb).append('(').append(this.name).append('=').append(this.value).append(')');
    }

    @Override
    public String getSimpleName() {
        return "pe";
    }
}

