/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.ModelMetaData;

public class PropertyStartsWith
extends NodeBase {
    private final String name;
    private final String starts;

    public PropertyStartsWith(String name, String starts) {
        this.name = name;
        this.starts = starts;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData, NodeBase.InstantiateContext context) {
        queryEngine.assertOperational();
        return queryEngine.getPersistentStore().getAndCheckCurrentTransaction().findStartingWith(entityType, this.name, this.starts);
    }

    @Override
    public NodeBase getClone() {
        return new PropertyStartsWith(this.name, this.starts);
    }

    @Override
    public void optimize(Sorts sorts, OptimizationPlan rules) {
        if (this.starts == null || this.starts.length() == 0) {
            NodeBase parent = this.getParent();
            parent.replaceChild(this, NodeFactory.all());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof PropertyStartsWith)) {
            return false;
        }
        PropertyStartsWith right = (PropertyStartsWith)obj;
        return Utils.safe_equals(this.name, right.name) && Utils.safe_equals(this.starts, right.starts);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.name + ' ' + this.starts + ") ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        return super.getHandle(sb).append('(').append(this.name).append(' ').append(this.starts).append(')');
    }

    @Override
    public String getSimpleName() {
        return "psw";
    }
}

