/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.SingleEntityIterable;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.query.AddNullStaticTypedEntityIterable;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.Concat;
import jetbrains.exodus.query.ExcludeNullStaticTypedEntityIterable;
import jetbrains.exodus.query.MetaDataAwareUniqueKeyIndicesEngine;
import jetbrains.exodus.query.Minus;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.QueryEngineKt;
import jetbrains.exodus.query.SortEngine;
import jetbrains.exodus.query.StaticTypedEntityIterable;
import jetbrains.exodus.query.StaticTypedIterableDecorator;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.exodus.util.SystemPropertyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J*\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010)\u001a\u00020*H\u0014J$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010)\u001a\u00020*H\u0014J*\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020*H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020*H\u0016J*\u00103\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0016\u00106\u001a\u0002072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0018\u00108\u001a\u0002072\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u00102\u001a\u00020*2\u0006\u0010;\u001a\u00020<H\u0016J(\u00109\u001a\u00020:2\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u00102\u001a\u00020*2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010>\u001a\u00020:2\u0006\u00102\u001a\u00020*H\u0016J\b\u0010?\u001a\u00020\u001cH\u0002J&\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010)\u001a\u00020*H\u0016J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020B2\u0006\u0010)\u001a\u00020*H\u0002J&\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010)\u001a\u00020*H\u0016J\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020B2\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0018\u0010I\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010J\u001a\u00020\u0019H\u0014J\u0010\u0010I\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020/H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR(\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006K"}, d2={"Ljetbrains/exodus/query/QueryEngine;", "Lmu/KLogging;", "modelMetaData", "Ljetbrains/exodus/query/metadata/ModelMetaData;", "persistentStore", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "(Ljetbrains/exodus/query/metadata/ModelMetaData;Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;)V", "_sortEngine", "Ljetbrains/exodus/query/SortEngine;", "getModelMetaData", "()Ljetbrains/exodus/query/metadata/ModelMetaData;", "getPersistentStore", "()Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "value", "sortEngine", "getSortEngine", "()Ljetbrains/exodus/query/SortEngine;", "setSortEngine", "(Ljetbrains/exodus/query/SortEngine;)V", "uniqueKeyIndicesEngine", "Ljetbrains/exodus/query/MetaDataAwareUniqueKeyIndicesEngine;", "getUniqueKeyIndicesEngine", "()Ljetbrains/exodus/query/MetaDataAwareUniqueKeyIndicesEngine;", "adjustEntityIterable", "", "Ljetbrains/exodus/entitystore/Entity;", "it", "assertOperational", "", "concat", "left", "right", "concatAdjusted", "concatNonTrees", "exclude", "excludeAdjusted", "excludeNonTrees", "inMemoryConcat", "inMemoryExclude", "inMemoryIntersect", "inMemorySelectDistinct", "linkName", "", "inMemorySelectManyDistinct", "inMemoryUnion", "instantiateAndAdjust", "instantiateGetAll", "Ljetbrains/exodus/entitystore/EntityIterable;", "txn", "Ljetbrains/exodus/entitystore/StoreTransaction;", "entityType", "intersect", "intersectAdjusted", "intersectNonTrees", "isPersistentIterable", "", "isWrapped", "query", "Ljetbrains/exodus/query/TreeKeepingEntityIterable;", "tree", "Ljetbrains/exodus/query/NodeBase;", "instance", "queryGetAll", "reportInMemoryError", "selectDistinct", "selectDistinctImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "selectManyDistinct", "selectManyDistinctImpl", "toEntityIterable", "union", "unionAdjusted", "unionNonTrees", "wrap", "entity", "xodus-query"})
public class QueryEngine
extends KLogging {
    @Nullable
    private final ModelMetaData modelMetaData;
    @NotNull
    private final PersistentEntityStoreImpl persistentStore;
    @Nullable
    private SortEngine _sortEngine;
    @NotNull
    private final MetaDataAwareUniqueKeyIndicesEngine uniqueKeyIndicesEngine;

    public QueryEngine(@Nullable ModelMetaData modelMetaData, @NotNull PersistentEntityStoreImpl persistentStore) {
        Intrinsics.checkNotNullParameter((Object)persistentStore, (String)"persistentStore");
        this.modelMetaData = modelMetaData;
        this.persistentStore = persistentStore;
        this.uniqueKeyIndicesEngine = new MetaDataAwareUniqueKeyIndicesEngine(this.persistentStore, this.modelMetaData);
    }

    @Nullable
    public final ModelMetaData getModelMetaData() {
        return this.modelMetaData;
    }

    @NotNull
    public final PersistentEntityStoreImpl getPersistentStore() {
        return this.persistentStore;
    }

    @Nullable
    public SortEngine getSortEngine() {
        return this._sortEngine;
    }

    /*
     * WARNING - void declaration
     */
    public void setSortEngine(@Nullable SortEngine value) {
        void $this$_set_sortEngine__u24lambda_u2d0;
        Object object = KodusKt.getNotNull((Object)value);
        SortEngine sortEngine = (SortEngine)object;
        QueryEngine queryEngine = this;
        boolean bl = false;
        $this$_set_sortEngine__u24lambda_u2d0.setQueryEngine(this);
        queryEngine._sortEngine = (SortEngine)object;
    }

    @NotNull
    public final MetaDataAwareUniqueKeyIndicesEngine getUniqueKeyIndicesEngine() {
        return this.uniqueKeyIndicesEngine;
    }

    @NotNull
    public TreeKeepingEntityIterable queryGetAll(@NotNull String entityType) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        NodeBase nodeBase = NodeFactory.all();
        Intrinsics.checkNotNullExpressionValue((Object)nodeBase, (String)"all()");
        return this.query(null, entityType, nodeBase);
    }

    @NotNull
    public TreeKeepingEntityIterable query(@NotNull String entityType, @NotNull NodeBase tree) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        return this.query(null, entityType, tree);
    }

    @NotNull
    public TreeKeepingEntityIterable query(@Nullable Iterable<? extends Entity> instance, @NotNull String entityType, @NotNull NodeBase tree) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        return new TreeKeepingEntityIterable(instance, entityType, tree, this);
    }

    @NotNull
    public Iterable<Entity> intersect(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left == right) {
            return left;
        }
        if (QueryEngineKt.access$isEmpty(left) || QueryEngineKt.access$isEmpty(right)) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)entityIterableBase, (String)"EMPTY");
            return (Iterable)entityIterableBase;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            String leftType = ((TreeKeepingEntityIterable)left).getEntityType();
            if (right instanceof TreeKeepingEntityIterable && ((TreeKeepingEntityIterable)left).getInstance() == ((TreeKeepingEntityIterable)right).getInstance()) {
                String rightType = ((TreeKeepingEntityIterable)right).getEntityType();
                Intrinsics.checkNotNullExpressionValue((Object)rightType, (String)"rightType");
                if (Utils.isTypeOf(leftType, rightType, (ModelMetaData)KodusKt.getNotNull((Object)this.modelMetaData))) {
                    return new TreeKeepingEntityIterable(((TreeKeepingEntityIterable)right).getInstance(), leftType, And.and(((TreeKeepingEntityIterable)left).getTree(), ((TreeKeepingEntityIterable)right).getTree()), ((TreeKeepingEntityIterable)left).annotatedTree, ((TreeKeepingEntityIterable)right).annotatedTree, this);
                }
                Intrinsics.checkNotNullExpressionValue((Object)leftType, (String)"leftType");
                if (Utils.isTypeOf(rightType, leftType, (ModelMetaData)KodusKt.getNotNull((Object)this.modelMetaData))) {
                    return new TreeKeepingEntityIterable(((TreeKeepingEntityIterable)right).getInstance(), rightType, And.and(((TreeKeepingEntityIterable)left).getTree(), ((TreeKeepingEntityIterable)right).getTree()), ((TreeKeepingEntityIterable)left).annotatedTree, ((TreeKeepingEntityIterable)right).annotatedTree, this);
                }
            }
        }
        String staticType = null;
        if (left instanceof StaticTypedEntityIterable) {
            String leftType = ((StaticTypedEntityIterable)left).getEntityType();
            if (right instanceof StaticTypedEntityIterable) {
                String rightType = ((StaticTypedEntityIterable)right).getEntityType();
                Intrinsics.checkNotNullExpressionValue((Object)leftType, (String)"leftType");
                if (Utils.isTypeOf(rightType, leftType, (ModelMetaData)KodusKt.getNotNull((Object)this.modelMetaData))) {
                    staticType = rightType;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)rightType, (String)"rightType");
                    if (Utils.isTypeOf(leftType, rightType, (ModelMetaData)KodusKt.getNotNull((Object)this.modelMetaData))) {
                        staticType = leftType;
                    }
                }
                if (Intrinsics.areEqual((Object)leftType, (Object)rightType)) {
                    if (QueryEngineKt.access$isGetAllTree((StaticTypedEntityIterable)left)) {
                        return new ExcludeNullStaticTypedEntityIterable(rightType, (StaticTypedEntityIterable)right, this);
                    }
                    if (QueryEngineKt.access$isGetAllTree((StaticTypedEntityIterable)right)) {
                        return new ExcludeNullStaticTypedEntityIterable(leftType, (StaticTypedEntityIterable)left, this);
                    }
                }
            }
        }
        Iterable result = this.intersectNonTrees(this.instantiateAndAdjust(left), this.instantiateAndAdjust(right));
        String string = staticType;
        if (string == null) {
            iterable = result;
        } else {
            String it = string;
            boolean bl = false;
            StaticTypedIterableDecorator staticTypedIterableDecorator = new StaticTypedIterableDecorator(staticType, result, this);
            iterable = staticTypedIterableDecorator;
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> union(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left == right) {
            return left;
        }
        if (QueryEngineKt.access$isEmpty(left)) {
            return right;
        }
        if (QueryEngineKt.access$isEmpty(right)) {
            return left;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            String leftType = ((TreeKeepingEntityIterable)left).getEntityType();
            if (right instanceof TreeKeepingEntityIterable && ((TreeKeepingEntityIterable)left).getInstance() == ((TreeKeepingEntityIterable)right).getInstance() && Intrinsics.areEqual((Object)leftType, (Object)((TreeKeepingEntityIterable)right).getEntityType())) {
                Iterable<Entity> iterable2 = ((TreeKeepingEntityIterable)right).getInstance();
                NodeBase nodeBase = ((TreeKeepingEntityIterable)left).getTree();
                Intrinsics.checkNotNullExpressionValue((Object)nodeBase, (String)"left.tree");
                NodeBase nodeBase2 = nodeBase;
                nodeBase = ((TreeKeepingEntityIterable)right).getTree();
                Intrinsics.checkNotNullExpressionValue((Object)nodeBase, (String)"right.tree");
                return new TreeKeepingEntityIterable(iterable2, leftType, Or.Companion.or(nodeBase2, nodeBase), ((TreeKeepingEntityIterable)left).annotatedTree, ((TreeKeepingEntityIterable)right).annotatedTree, this);
            }
        }
        String staticType = null;
        if (left instanceof StaticTypedEntityIterable) {
            String rightType;
            String leftType = ((StaticTypedEntityIterable)left).getEntityType();
            if (right instanceof StaticTypedEntityIterable && Intrinsics.areEqual((Object)leftType, (Object)(rightType = ((StaticTypedEntityIterable)right).getEntityType()))) {
                staticType = rightType;
                if (QueryEngineKt.access$isGetAllTree((StaticTypedEntityIterable)left)) {
                    return new AddNullStaticTypedEntityIterable(staticType, (StaticTypedEntityIterable)left, (StaticTypedEntityIterable)right, this);
                }
                if (QueryEngineKt.access$isGetAllTree((StaticTypedEntityIterable)right)) {
                    return new AddNullStaticTypedEntityIterable(staticType, (StaticTypedEntityIterable)right, (StaticTypedEntityIterable)left, this);
                }
            }
        }
        Iterable result = this.unionNonTrees(this.instantiateAndAdjust(left), this.instantiateAndAdjust(right));
        String string = staticType;
        if (string == null) {
            iterable = result;
        } else {
            String it = string;
            boolean bl = false;
            StaticTypedIterableDecorator staticTypedIterableDecorator = new StaticTypedIterableDecorator(staticType, result, this);
            iterable = staticTypedIterableDecorator;
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> concat(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (QueryEngineKt.access$isEmpty(left)) {
            return right;
        }
        if (QueryEngineKt.access$isEmpty(right)) {
            return left;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            String leftType = ((TreeKeepingEntityIterable)left).getEntityType();
            if (right instanceof TreeKeepingEntityIterable && ((TreeKeepingEntityIterable)left).getInstance() == ((TreeKeepingEntityIterable)right).getInstance() && Intrinsics.areEqual((Object)leftType, (Object)((TreeKeepingEntityIterable)right).getEntityType())) {
                return new TreeKeepingEntityIterable(((TreeKeepingEntityIterable)right).getInstance(), leftType, new Concat(((TreeKeepingEntityIterable)left).getTree(), ((TreeKeepingEntityIterable)right).getTree()), ((TreeKeepingEntityIterable)left).annotatedTree, ((TreeKeepingEntityIterable)right).annotatedTree, this);
            }
        }
        String staticType = QueryEngineKt.access$retrieveStaticType(left, right);
        Iterable result = this.concatNonTrees(this.instantiateAndAdjust(left), this.instantiateAndAdjust(right));
        String string = staticType;
        if (string == null) {
            iterable = result;
        } else {
            String it = string;
            boolean bl = false;
            StaticTypedIterableDecorator staticTypedIterableDecorator = new StaticTypedIterableDecorator(staticType, result, this);
            iterable = staticTypedIterableDecorator;
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> exclude(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (QueryEngineKt.access$isEmpty(left) || left == right) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)entityIterableBase, (String)"EMPTY");
            return (Iterable)entityIterableBase;
        }
        if (QueryEngineKt.access$isEmpty(right)) {
            return left;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            String leftType = ((TreeKeepingEntityIterable)left).getEntityType();
            if (right instanceof TreeKeepingEntityIterable && ((TreeKeepingEntityIterable)left).getInstance() == ((TreeKeepingEntityIterable)right).getInstance() && Intrinsics.areEqual((Object)leftType, (Object)((TreeKeepingEntityIterable)right).getEntityType())) {
                return new TreeKeepingEntityIterable(((TreeKeepingEntityIterable)right).getInstance(), leftType, new Minus(((TreeKeepingEntityIterable)left).getTree(), ((TreeKeepingEntityIterable)right).getTree()), ((TreeKeepingEntityIterable)left).annotatedTree, ((TreeKeepingEntityIterable)right).annotatedTree, this);
            }
        }
        String staticType = QueryEngineKt.access$retrieveStaticType(left, right);
        Iterable result = this.excludeNonTrees(this.instantiateAndAdjust(left), this.instantiateAndAdjust(right));
        String string = staticType;
        if (string == null) {
            iterable = result;
        } else {
            String it = string;
            boolean bl = false;
            StaticTypedIterableDecorator staticTypedIterableDecorator = new StaticTypedIterableDecorator(staticType, result, this);
            iterable = staticTypedIterableDecorator;
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> selectDistinct(@Nullable Iterable<? extends Entity> it, @NotNull String linkName) {
        Intrinsics.checkNotNullParameter((Object)linkName, (String)"linkName");
        if (it == null) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)entityIterableBase, (String)"EMPTY");
            return (Iterable)entityIterableBase;
        }
        if (this.modelMetaData != null) {
            if (it instanceof StaticTypedEntityIterable) {
                EntityMetaData emd;
                String entityType = ((StaticTypedEntityIterable)it).getEntityType();
                Iterable<Entity> it2 = this.toEntityIterable(it);
                boolean bl = false;
                if (QueryEngineKt.access$isPersistent(it2) && (emd = this.getModelMetaData().getEntityMetaData(entityType)) != null) {
                    AssociationEndMetaData associationEndMetaData = emd.getAssociationEndMetaData(linkName);
                    if (associationEndMetaData != null) {
                        AssociationEndMetaData aemd = associationEndMetaData;
                        boolean bl2 = false;
                        return new StaticTypedIterableDecorator(aemd.getOppositeEntityMetaData().getType(), this.selectDistinctImpl((EntityIterableBase)it2, linkName), this);
                    }
                }
            } else if (QueryEngineKt.access$isPersistent(it)) {
                return this.selectDistinctImpl((EntityIterableBase)it, linkName);
            }
        }
        return this.inMemorySelectDistinct(it, linkName);
    }

    @NotNull
    public Iterable<Entity> selectManyDistinct(@Nullable Iterable<? extends Entity> it, @NotNull String linkName) {
        Intrinsics.checkNotNullParameter((Object)linkName, (String)"linkName");
        if (it == null) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)entityIterableBase, (String)"EMPTY");
            return (Iterable)entityIterableBase;
        }
        if (this.modelMetaData != null) {
            if (it instanceof StaticTypedEntityIterable) {
                EntityMetaData emd;
                String entityType = ((StaticTypedEntityIterable)it).getEntityType();
                Iterable<Entity> it2 = this.toEntityIterable(it);
                boolean bl = false;
                if (QueryEngineKt.access$isPersistent(it2) && (emd = this.getModelMetaData().getEntityMetaData(entityType)) != null) {
                    AssociationEndMetaData associationEndMetaData = emd.getAssociationEndMetaData(linkName);
                    if (associationEndMetaData != null) {
                        AssociationEndMetaData aemd = associationEndMetaData;
                        boolean bl2 = false;
                        return new StaticTypedIterableDecorator(aemd.getOppositeEntityMetaData().getType(), this.selectManyDistinctImpl((EntityIterableBase)it2, linkName), this);
                    }
                }
            } else if (QueryEngineKt.access$isPersistent(it)) {
                return this.selectManyDistinctImpl((EntityIterableBase)it, linkName);
            }
        }
        return this.inMemorySelectManyDistinct(it, linkName);
    }

    @NotNull
    public Iterable<Entity> toEntityIterable(@NotNull Iterable<? extends Entity> it) {
        Intrinsics.checkNotNullParameter(it, (String)"it");
        Iterable<? extends Entity> iterable = it instanceof StaticTypedEntityIterable ? ((StaticTypedEntityIterable)it).instantiate() : it;
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"if (it is StaticTypedEnt\u2026 it.instantiate() else it");
        return this.adjustEntityIterable(iterable);
    }

    @NotNull
    public Iterable<Entity> intersectNonTrees(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (QueryEngineKt.access$isPersistent(left) && QueryEngineKt.access$isPersistent(right)) {
            EntityIterable entityIterable = ((EntityIterableBase)left).getSource().intersect((EntityIterable)((EntityIterableBase)right).getSource());
            Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"left as EntityIterableBa\u2026tityIterableBase).source)");
            iterable = (Iterable)this.wrap(entityIterable);
        } else {
            iterable = this.inMemoryIntersect(left, right);
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> unionNonTrees(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (QueryEngineKt.access$isPersistent(left) && QueryEngineKt.access$isPersistent(right)) {
            EntityIterable entityIterable = ((EntityIterableBase)left).getSource().union((EntityIterable)((EntityIterableBase)right).getSource());
            Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"left as EntityIterableBa\u2026tityIterableBase).source)");
            iterable = (Iterable)this.wrap(entityIterable);
        } else {
            iterable = this.inMemoryUnion(left, right);
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> concatNonTrees(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (QueryEngineKt.access$isPersistent(left) && QueryEngineKt.access$isPersistent(right)) {
            EntityIterable entityIterable = ((EntityIterableBase)left).getSource().concat((EntityIterable)((EntityIterableBase)right).getSource());
            Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"left as EntityIterableBa\u2026tityIterableBase).source)");
            iterable = (Iterable)this.wrap(entityIterable);
        } else {
            iterable = this.inMemoryConcat(left, right);
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> excludeNonTrees(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (QueryEngineKt.access$isPersistent(left) && QueryEngineKt.access$isPersistent(right)) {
            EntityIterable entityIterable = ((EntityIterableBase)left).getSource().minus((EntityIterable)((EntityIterableBase)right).getSource());
            Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"left as EntityIterableBa\u2026tityIterableBase).source)");
            iterable = (Iterable)this.wrap(entityIterable);
        } else {
            iterable = this.inMemoryExclude(left, right);
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> adjustEntityIterable(@NotNull Iterable<? extends Entity> it) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(it, (String)"it");
        if (it == EntityIterableBase.EMPTY) {
            return it;
        }
        if (it instanceof Collection) {
            Collection $this$adjustEntityIterable_u24lambda_u2d10 = (Collection)it;
            boolean bl = false;
            if ($this$adjustEntityIterable_u24lambda_u2d10.isEmpty()) {
                EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)entityIterableBase, (String)"EMPTY");
                return (Iterable)entityIterableBase;
            }
            if ($this$adjustEntityIterable_u24lambda_u2d10.size() == 1) {
                Iterable<Entity> iterable2 = this.wrap((Entity)$this$adjustEntityIterable_u24lambda_u2d10.iterator().next());
                if (iterable2 != null) {
                    Iterable<Entity> it2 = iterable2;
                    boolean bl2 = false;
                    return this.adjustEntityIterable(it2);
                }
            }
        }
        if (QueryEngineKt.access$isPersistent(it) && !this.isWrapped(it)) {
            EntityIterableBase entityIterableBase = ((EntityIterableBase)it).getSource();
            Intrinsics.checkNotNullExpressionValue((Object)entityIterableBase, (String)"it as EntityIterableBase).source");
            iterable = (Iterable)this.wrap((EntityIterable)entityIterableBase);
        } else {
            iterable = it;
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> intersectAdjusted(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return this.intersectNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    @NotNull
    public Iterable<Entity> unionAdjusted(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return this.unionNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    @NotNull
    public Iterable<Entity> concatAdjusted(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return this.concatNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    @NotNull
    public Iterable<Entity> excludeAdjusted(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return this.excludeNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    @NotNull
    public EntityIterable instantiateGetAll(@NotNull String entityType) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        PersistentStoreTransaction persistentStoreTransaction = this.persistentStore.getAndCheckCurrentTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)persistentStoreTransaction, (String)"persistentStore.andCheckCurrentTransaction");
        return this.instantiateGetAll((StoreTransaction)persistentStoreTransaction, entityType);
    }

    @NotNull
    public EntityIterable instantiateGetAll(@NotNull StoreTransaction txn, @NotNull String entityType) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        EntityIterable entityIterable = txn.getAll(entityType);
        Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"txn.getAll(entityType)");
        return entityIterable;
    }

    public boolean isPersistentIterable(@NotNull Iterable<? extends Entity> it) {
        Intrinsics.checkNotNullParameter(it, (String)"it");
        return QueryEngineKt.access$isPersistent(it);
    }

    public void assertOperational() {
    }

    public boolean isWrapped(@Nullable Iterable<? extends Entity> it) {
        return true;
    }

    @NotNull
    public EntityIterable wrap(@NotNull EntityIterable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Iterable<Entity> inMemorySelectDistinct(@NotNull Iterable<? extends Entity> it, @NotNull String linkName) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)linkName, (String)"linkName");
        this.reportInMemoryError();
        Iterable $this$mapNotNull$iv = CollectionsKt.toList(it);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Entity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Entity it2 = (Entity)element$iv$iv;
            boolean bl2 = false;
            if (it2.getLink(linkName) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return QueryEngineKt.access$distinct((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Iterable<Entity> inMemorySelectManyDistinct(@NotNull Iterable<? extends Entity> it, @NotNull String linkName) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)linkName, (String)"linkName");
        this.reportInMemoryError();
        Iterable $this$flatMap$iv = CollectionsKt.toList(it);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Entity it2 = (Entity)element$iv$iv;
            boolean bl = false;
            EntityIterable entityIterable = it2.getLinks(linkName);
            Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"it.getLinks(linkName)");
            Iterable list$iv$iv = (Iterable)entityIterable;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return QueryEngineKt.access$distinct(CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Iterable<Entity> inMemoryIntersect(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        this.reportInMemoryError();
        EntityIdSet ids = QueryEngineKt.access$getAsEntityIdSet(right);
        if (ids.isEmpty()) {
            iterable = right;
        } else {
            void $this$filterTo$iv$iv;
            Iterable<? extends Entity> $this$filter$iv = left;
            boolean $i$f$filter = false;
            Iterable<? extends Entity> iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entity it = (Entity)element$iv$iv;
                boolean bl = false;
                if (!ids.contains(it.getId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        }
        return iterable;
    }

    @NotNull
    protected Iterable<Entity> inMemoryUnion(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        this.reportInMemoryError();
        return CollectionsKt.union(left, right);
    }

    @NotNull
    protected Iterable<Entity> inMemoryConcat(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        List list;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        this.reportInMemoryError();
        List $this$inMemoryConcat_u24lambda_u2d14 = list = CollectionsKt.toMutableList(left);
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$inMemoryConcat_u24lambda_u2d14, right);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Iterable<Entity> inMemoryExclude(@NotNull Iterable<? extends Entity> left, @NotNull Iterable<? extends Entity> right) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        this.reportInMemoryError();
        EntityIdSet ids = QueryEngineKt.access$getAsEntityIdSet(right);
        if (ids.isEmpty()) {
            iterable = left;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = left;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entity it = (Entity)element$iv$iv;
                boolean bl = false;
                if (!(!ids.contains(it.getId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        }
        return iterable;
    }

    @Nullable
    protected Iterable<Entity> wrap(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return (Iterable)new SingleEntityIterable(this.persistentStore.getAndCheckCurrentTransaction(), entity.getId());
    }

    private final Iterable<Entity> instantiateAndAdjust(Iterable<? extends Entity> it) {
        Iterable<Entity> iterable = StaticTypedEntityIterable.instantiate(it);
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"instantiate(it)");
        return this.adjustEntityIterable(iterable);
    }

    private final Iterable<Entity> selectDistinctImpl(EntityIterableBase it, String linkName) {
        this.assertOperational();
        EntityIterable entityIterable = it.getSource().selectDistinct(linkName);
        Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"it.source.selectDistinct(linkName)");
        return (Iterable)this.wrap(entityIterable);
    }

    private final Iterable<Entity> selectManyDistinctImpl(EntityIterableBase it, String linkName) {
        this.assertOperational();
        EntityIterable entityIterable = it.getSource().selectManyDistinct(linkName);
        Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"it.source.selectManyDistinct(linkName)");
        return (Iterable)this.wrap(entityIterable);
    }

    private final void reportInMemoryError() {
        SystemPropertyKt.doIfTrue((String)"jetbrains.exodus.query.reportInMemoryQueries", (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ QueryEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getLogger().error("QueryEngine does in-memory computations", new Throwable());
            }
        }));
    }
}

