/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.NanoSet;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.InsertConstraintException;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.SingleColumnTable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.query.metadata.Index;
import jetbrains.exodus.query.metadata.IndexField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueKeyIndicesEngine {
    private static final Logger logger = LoggerFactory.getLogger(UniqueKeyIndicesEngine.class);
    @NonNls
    private static final String UNIQUEKEY_INDEX = "uniquekey.index";
    private final PersistentEntityStoreImpl persistentStore;

    UniqueKeyIndicesEngine(PersistentEntityStoreImpl persistentStore) {
        this.persistentStore = persistentStore;
    }

    public void updateUniqueKeyIndices(@NotNull Iterable<Index> indices) {
        Environment environment = this.persistentStore.getEnvironment();
        environment.suspendGC();
        try {
            this.persistentStore.executeInTransaction(txn -> {
                PersistentStoreTransaction t = (PersistentStoreTransaction)txn;
                PersistentStoreTransaction snapshot = t.getSnapshot();
                try {
                    HashSet indexNames = new HashSet();
                    for (String dbName : environment.getAllStoreNames(t.getEnvironmentTransaction())) {
                        if (!this.isUniqueKeyIndexName(dbName)) continue;
                        indexNames.add(dbName);
                    }
                    for (Index index : indices) {
                        String indexName = this.getUniqueKeyIndexName(index);
                        if (indexNames.contains(indexName)) {
                            indexNames.remove(indexName);
                            continue;
                        }
                        this.createUniqueKeyIndex(t, snapshot, index);
                    }
                    for (String indexName : indexNames) {
                        this.removeObsoleteUniqueKeyIndex(t, indexName);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Flush index persistent transaction " + t);
                    }
                    t.flush();
                }
                finally {
                    snapshot.abort();
                }
            });
        }
        finally {
            environment.resumeGC();
        }
    }

    public void insertUniqueKey(@NotNull PersistentStoreTransaction txn, @NotNull Index index, @NotNull List<Comparable> propValues, @NotNull Entity entity) {
        PropertyTypes propertyTypes = this.persistentStore.getPropertyTypes();
        int propCount = index.getFields().size();
        if (propCount != propValues.size()) {
            throw new IllegalArgumentException("Number of fields differs from the number of property values");
        }
        Store indexTable = this.getUniqueKeyIndex(txn, index);
        if (!indexTable.add(txn.getEnvironmentTransaction(), (ByteIterable)propertyTypes.dataArrayToEntry(propValues.toArray(new Comparable[propCount])), (ByteIterable)LongBinding.longToCompressedEntry((long)entity.getId().getLocalId()))) {
            throw new InsertConstraintException("Failed to insert unique key (already exists). Index: " + index);
        }
    }

    public void deleteUniqueKey(@NotNull PersistentStoreTransaction txn, @NotNull Index index, @NotNull List<Comparable> propValues) {
        PropertyTypes propertyTypes = this.persistentStore.getPropertyTypes();
        int propCount = index.getFields().size();
        if (propCount != propValues.size()) {
            throw new IllegalArgumentException("Number of fields differs from the number of property values");
        }
        this.getUniqueKeyIndex(txn, index).delete(txn.getEnvironmentTransaction(), (ByteIterable)propertyTypes.dataArrayToEntry(propValues.toArray(new Comparable[propCount])));
    }

    private void removeObsoleteUniqueKeyIndex(@NotNull PersistentStoreTransaction txn, @NotNull String indexName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Remove obsolete index [" + indexName + ']');
        }
        this.persistentStore.getEnvironment().removeStore(indexName, txn.getEnvironmentTransaction());
    }

    private void createUniqueKeyIndex(@NotNull PersistentStoreTransaction txn, @NotNull PersistentStoreTransaction snapshot, @NotNull Index index) {
        if (logger.isDebugEnabled()) {
            logger.debug("Create index [" + index + ']');
        }
        Environment environment = this.persistentStore.getEnvironment();
        PersistentEntityStoreConfig config = this.persistentStore.getConfig();
        PropertyTypes propertyTypes = this.persistentStore.getPropertyTypes();
        List<IndexField> fields = index.getFields();
        int propCount = fields.size();
        if (propCount == 0) {
            throw new EntityStoreException("Can't create unique key index on empty list of keys.");
        }
        SingleColumnTable indexTable = null;
        Object[] props = new Comparable[propCount];
        for (String entityType : this.getEntityTypesToIndex(index)) {
            int i = 0;
            for (Entity entity : snapshot.getAll(entityType)) {
                for (int j = 0; j < propCount; ++j) {
                    IndexField field = fields.get(j);
                    if (field.isProperty()) {
                        props[j] = this.persistentStore.getProperty(txn, (PersistentEntity)entity, field.getName());
                        if (props[j] != null) continue;
                        throw new EntityStoreException("Can't create unique key index with null property value: " + entityType + '.' + field.getName());
                    }
                    props[j] = entity.getLink(field.getName());
                    if (props[j] != null) continue;
                    throw new EntityStoreException("Can't create unique key index with null link: " + entityType + '.' + field.getName());
                }
                if (indexTable == null) {
                    String uniqueKeyIndexName;
                    indexTable = new SingleColumnTable(txn, uniqueKeyIndexName, environment.storeExists(uniqueKeyIndexName = this.getUniqueKeyIndexName(index), txn.getEnvironmentTransaction()) ? StoreConfig.USE_EXISTING : StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING);
                }
                ArrayByteIterable propsEntry = propertyTypes.dataArrayToEntry((Comparable[])props);
                if (!indexTable.getDatabase().add(txn.getEnvironmentTransaction(), (ByteIterable)propsEntry, (ByteIterable)LongBinding.longToCompressedEntry((long)entity.getId().getLocalId()))) {
                    ByteIterable oldEntityIdEntry = indexTable.getDatabase().get(txn.getEnvironmentTransaction(), (ByteIterable)propsEntry);
                    long oldEntityId = LongBinding.compressedEntryToLong((ByteIterable)oldEntityIdEntry);
                    throw new EntityStoreException("Failed to insert unique key (already exists), index: " + index + ", values = " + Arrays.toString(props) + ", new entity = " + entity + ", old entity id = " + oldEntityId + ", index owner entity type = " + index.getOwnerEntityType());
                }
                if (++i % 100 != 0) continue;
                txn.flush();
            }
            txn.flush();
        }
    }

    protected Set<String> getEntityTypesToIndex(@NotNull Index index) {
        return new NanoSet((Object)index.getOwnerEntityType());
    }

    @NotNull
    private Store getUniqueKeyIndex(@NotNull PersistentStoreTransaction txn, @NotNull Index index) {
        return this.persistentStore.getEnvironment().openStore(this.getUniqueKeyIndexName(index), StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn.getEnvironmentTransaction());
    }

    private String getUniqueKeyIndexName(@NotNull Index index) {
        List<IndexField> fields = index.getFields();
        int fieldCount = fields.size();
        if (fieldCount < 1) {
            throw new EntityStoreException("Can't define unique key on empty set of fields");
        }
        LinkedHashMap names = new LinkedHashMap();
        for (IndexField field : fields) {
            String name = field.getName();
            Boolean b = (Boolean)names.get((Object)name);
            if (b != null && b.booleanValue() == field.isProperty()) {
                throw new EntityStoreException("Can't define unique key, field is used twice: " + name);
            }
            names.put((Object)name, (Object)field.isProperty());
        }
        return this.getUniqueKeyIndexName(index.getOwnerEntityType(), (LinkedHashMap<String, Boolean>)names);
    }

    @NotNull
    private String getUniqueKeyIndexName(String prefix, LinkedHashMap<String, Boolean> fieldNames) {
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry fieldEntry : fieldNames.entrySet()) {
            String name = (String)fieldEntry.getKey();
            params.add((Boolean)fieldEntry.getValue() != false ? name : name + "@link");
        }
        return this.getFQName(UNIQUEKEY_INDEX + prefix, params.toArray());
    }

    private boolean isUniqueKeyIndexName(String indexName) {
        int prefixLen = this.persistentStore.getName().length() + 1;
        return indexName.length() > prefixLen && indexName.substring(prefixLen).startsWith(UNIQUEKEY_INDEX);
    }

    @NotNull
    private String getFQName(@NotNull String localName, Object ... params) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.persistentStore.getName());
        builder.append('.');
        builder.append(localName);
        for (Object param : params) {
            builder.append('#');
            builder.append(param);
        }
        return builder.toString();
    }
}

