#!/bin/bash
# 强制完全重新编译

cd "$(dirname "$0")"

echo "========================================"
echo "强制完全重新编译"
echo "========================================"
echo ""

# 1. 显示当前状态
echo "1. 当前文件状态："
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
ls -lh target/release/bin/cli 2>/dev/null && echo "  可执行文件: 存在" || echo "  可执行文件: 不存在"
ls -lh ffi/librawinput.dylib 2>/dev/null && echo "  FFI 库: 存在" || echo "  FFI 库: 不存在"
echo ""

# 2. 验证源代码修复
echo "2. 验证源代码修复："
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
if grep -q "if (len <= 0)" src/io/raw_input_utils_unix.cj; then
    echo "  ✅ Unix/macOS 版本已修复"
    grep -A 2 "if (len <= 0)" src/io/raw_input_utils_unix.cj | head -3
else
    echo "  ❌ Unix/macOS 版本未修复"
    exit 1
fi
echo ""

if grep -q "if (len < 0)" src/io/raw_input_utils_win.cj; then
    echo "  ✅ Windows 版本已修复"
else
    echo "  ❌ Windows 版本未修复"
    exit 1
fi
echo ""

# 3. 完全清理
echo "3. 完全清理所有缓存和编译产物："
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "  清理 target/"
rm -rf target/
echo "  清理 build-script-cache/"
rm -rf build-script-cache/
echo "  清理 FFI 库"
rm -f ffi/*.dylib ffi/*.so ffi/*.dll ffi/*.a ffi/*.o
echo "  清理 .cjpm 缓存"
rm -rf .cjpm-cache/ 2>/dev/null
echo "  ✅ 清理完成"
echo ""

# 4. 重新编译
echo "4. 重新编译："
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
if cjpm build 2>&1 | tee /tmp/codelin_build.log | grep -E "(success|error|Building)"; then
    echo ""
    echo "  ✅ 编译完成"
else
    echo ""
    echo "  ❌ 编译失败"
    echo "  查看完整日志: /tmp/codelin_build.log"
    exit 1
fi
echo ""

# 5. 验证编译结果
echo "5. 验证编译结果："
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
if [ -f "target/release/bin/cli" ]; then
    echo "  ✅ 可执行文件: target/release/bin/cli"
    ls -lh target/release/bin/cli
    echo "  MD5: $(md5 -q target/release/bin/cli 2>/dev/null || md5sum target/release/bin/cli | cut -d' ' -f1)"
else
    echo "  ❌ 可执行文件不存在"
    exit 1
fi
echo ""

if [ -f "ffi/librawinput.dylib" ] || [ -f "ffi/librawinput.so" ]; then
    echo "  ✅ FFI 库已编译"
    ls -lh ffi/lib*.{dylib,so} 2>/dev/null | head -1
else
    echo "  ❌ FFI 库不存在"
    exit 1
fi
echo ""

# 6. 快速测试
echo "6. 快速 EOF 测试："
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "  测试: 空输入"
if echo "" | cjpm run --name cli 2>&1 | grep -q "Exception.*Read bytes 4294967295"; then
    echo "  ❌ 测试失败: 仍然抛出异常！"
    echo ""
    echo "异常信息:"
    echo "" | cjpm run --name cli 2>&1 | grep -A 3 "Exception"
    exit 1
else
    echo "  ✅ 测试通过: 无异常"
fi
echo ""

echo "========================================"
echo "✅ 重新编译完成"
echo "========================================"
echo ""
echo "现在可以运行:"
echo "  cjpm run --name cli"
echo ""
echo "测试 Ctrl+D:"
echo "  1. 运行程序"
echo "  2. 在提示符处按 Ctrl+D"
echo "  3. 验证程序优雅退出（无异常）"
echo ""

