#!/bin/bash

# Codelin 快速测试脚本
# 验证 Session 功能和 Claude Code 风格实现

echo "════════════════════════════════════════════════════════════════"
echo "  Codelin 快速测试 (Session 功能验证)"
echo "════════════════════════════════════════════════════════════════"
echo ""

cd /Users/louloulin/Documents/linchong/cjproject/codelin

GREEN='\033[0;32m'
BLUE='\033[0;34m'
CYAN='\033[0;36m'
NC='\033[0m'

echo -e "${CYAN}测试准备${NC}"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""

# 1. 编译检查
echo -e "${BLUE}1. 编译检查${NC}"
if cjpm build > /dev/null 2>&1; then
    echo -e "   ${GREEN}✅ 编译成功${NC}"
else
    echo -e "   ❌ 编译失败，请先修复编译错误"
    exit 1
fi

# 2. 检查 Session 数据
echo ""
echo -e "${BLUE}2. Session 数据检查${NC}"
if [ -f .codelin/sessions/metadata/last-conversation.json ]; then
    echo -e "   ${GREEN}✅ Session 元数据存在${NC}"
    echo "   当前会话："
    cat .codelin/sessions/metadata/last-conversation.json | grep '"title"' | sed 's/^/     /'
else
    echo "   ⚪ 无 Session 数据（首次运行正常）"
fi

# 3. 功能检查
echo ""
echo -e "${BLUE}3. 核心功能检查${NC}"
echo -n "   autoResume: "
if grep -q "autoResume" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✅${NC}"
else
    echo "❌"
fi

echo -n "   fileCount: "
if grep -q "countFilesInConversation" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✅${NC}"
else
    echo "❌"
fi

echo -n "   AI naming: "
if grep -q "@ai" src/core/conversation/session_auto_namer.cj; then
    echo -e "${GREEN}✅${NC}"
else
    echo "❌"
fi

echo -n "   Simple UI: "
if grep -q "buildPrompt" src/io/input_utils.cj; then
    echo -e "${GREEN}✅${NC}"
else
    echo "❌"
fi

echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo -e "${GREEN}✅ 所有检查通过，可以运行 CLI 测试${NC}"
echo ""
echo -e "${CYAN}运行 CLI:${NC}"
echo "  cjpm run --name cli"
echo ""
echo -e "${CYAN}测试命令：${NC}"
echo "  /sessions          - 查看会话列表"
echo "  /rename Test       - 重命名会话"
echo "  /new               - 创建新会话"
echo "  /exit              - 退出（自动保存）"
echo ""
echo "重新启动后会自动恢复上次会话（类似 claude -r）"
echo ""
echo "════════════════════════════════════════════════════════════════"

