#!/bin/bash
# 简单直接的 EOF 测试

cd "$(dirname "$0")"

echo "========================================"
echo "EOF 修复验证（简单测试）"
echo "========================================"
echo ""

echo "✅ 编译状态："
echo "   源代码: 已修复 (len <= 0 检查)"
echo "   FFI库: $(stat -f "%Sm" -t "%Y-%m-%d %H:%M" ffi/librawinput.dylib)"
echo "   可执行文件: $(stat -f "%Sm" -t "%Y-%m-%d %H:%M" target/release/bin/cli)"
echo ""

echo "📝 源代码验证："
grep -A 3 "// Handle EOF or read error" src/io/raw_input_utils_unix.cj | head -6
echo ""

echo "========================================"
echo "🎯 现在请手动测试："
echo "========================================"
echo ""
echo "1. 运行以下命令："
echo "   cjpm run --name cli"
echo ""
echo "2. 在提示符  > 处按 Ctrl+D"
echo ""
echo "3. 观察结果："
echo "   ✅ 期望：程序正常退出，不显示异常"
echo "   ❌ 如果看到：Exception: Read bytes 4294967295"
echo ""
echo "按 Enter 开始..."
read

# 清理 build-script-cache
rm -rf build-script-cache/

# 启动程序
cjpm run --name cli

echo ""
echo "========================================"
echo "测试完成"
echo "========================================"

