# AI Agent 重命名计划

**日期**: 2025-11-18 14:00  
**目标**: 将 AI Agent 类名改为 CodeLin 相关命名

---

## 🎯 重命名方案

### 主 Agent

| 当前名称 | 新名称 | 说明 |
|---------|--------|------|
| `GeneralCodeAgent` | `CodeLinAgent` | 通用代码 Agent |
| `CangjieCodeAgent` | `CodeLinCangjieAgent` | Cangjie 专用 Agent |

**理由**: 
- 统一命名为 CodeLin 开头
- 体现产品品牌身份
- Prompt 中已经自称 "Codelin"，类名应该一致

---

## 📋 需要修改的文件

### 1. Agent 定义文件

#### 1.1 GeneralCodeAgent → CodeLinAgent
**文件**: `src/core/agents/general_code_agent.cj`

**修改**:
```cangjie
// 之前
public class GeneralCodeAgent {

// 之后  
public class CodeLinAgent {
```

#### 1.2 CangjieCodeAgent → CodeLinCangjieAgent
**文件**: `src/core/agents/cangjie_code_agent.cj`

**修改**:
```cangjie
// 之前
public class CangjieCodeAgent {

// 之后
public class CodeLinCangjieAgent {
```

---

### 2. 使用 Agent 的文件

#### 2.1 主应用
**文件**: `src/app/cli_app.cj`

**修改**:
```cangjie
// 之前
import cli.core.agents.{GeneralCodeAgent, CangjieCodeAgent, ...}

this.agent = if (CliConfig.language.toAsciiLower() == 'cangjie') {
    CangjieCodeAgent()
} else {
    GeneralCodeAgent()
}

// 之后
import cli.core.agents.{CodeLinAgent, CodeLinCangjieAgent, ...}

this.agent = if (CliConfig.language.toAsciiLower() == 'cangjie') {
    CodeLinCangjieAgent()
} else {
    CodeLinAgent()
}
```

---

### 3. 其他可能引用的文件

需要搜索并更新所有引用：
- 文档
- 注释
- 测试文件
- 配置文件

---

## 🔍 搜索影响范围

### 搜索命令
```bash
# 搜索 GeneralCodeAgent
grep -r "GeneralCodeAgent" src/

# 搜索 CangjieCodeAgent  
grep -r "CangjieCodeAgent" src/
```

---

## ✅ 执行步骤

1. [x] 分析现有 Agent 结构
2. [x] 确定重命名方案
3. [ ] 重命名 GeneralCodeAgent → CodeLinAgent
4. [ ] 重命名 CangjieCodeAgent → CodeLinCangjieAgent
5. [ ] 更新所有导入引用
6. [ ] 更新文档和注释
7. [ ] 编译测试
8. [ ] 功能验证

---

## 📊 影响评估

### 文件数量
- Agent 定义文件: 2
- 主应用文件: 1
- 其他引用: 待确认

### 风险等级
- **低风险**: 只是类名重命名
- **影响范围**: 主要在 Agent 系统
- **向后兼容**: 不影响用户配置

---

## 🎨 品牌一致性

重命名后的效果：

**之前**:
```cangjie
class GeneralCodeAgent  // 通用名称，无品牌特色
class CangjieCodeAgent  // 只体现语言，无品牌
```

**之后**:
```cangjie
class CodeLinAgent           // ✅ 体现 CodeLin 品牌
class CodeLinCangjieAgent    // ✅ CodeLin + 语言特性
```

**Prompt 自我介绍**:
```
You are Codelin, an interactive CLI Coding Agent...
```

现在类名和自我介绍完全一致！✅

---

## 📝 下一步

1. 执行重命名
2. 更新 codelin.txt
3. 验证编译
4. 更新文档
