# Workspace目录分析问题诊断报告

**问题日期**: 2025-01-XX  
**问题**: 使用 `-w trader` 后，DirectoryAnalyzerAgent 仍然分析当前目录而不是trader目录  
**状态**: 🔍 **分析中**

---

## 📋 问题现象

从终端输出可以看到：

```
○ Execute Shell Command
  pwd
  → Executing...
  ✓ Model Code Lin Agent completed

✓ List Directory
  /Users/louloulin/Documents/linchong/gitcode/magic/codelin  // ❌ 应该是trader目录
  ✓ Model Code Lin Agent completed

✓ Directory Analyzer Agent
  question: 分析当前目录的结构和内容，了解这是什么项目，包含哪些重要文件和目录结构
      ✓ Model Code Lin Agent completed

  ✓ Execute Shell Command
    ls -la
```

**问题**:
- `pwd` 显示的是 `/Users/louloulin/Documents/linchong/gitcode/magic/codelin`，而不是trader目录
- `List Directory` 显示的是当前目录，而不是trader目录
- `DirectoryAnalyzerAgent` 分析的是当前目录，而不是trader目录

---

## 🔍 问题分析

### 问题1: DirectoryAnalyzerAgent Prompt使用编译时插值 ❌

**文件**: `src/core/agents/subagents/explorer_agent.cj:341, 346`

```cangjie
## Responsibilities
- Map the high-level structure of the project at **${CliConfig.cwd}**.  // ❌ 编译时插值！

## Required Steps
1. Start with `listDirectory("${CliConfig.cwd}")`, then dive into key folders.  // ❌ 编译时插值！
```

**问题**: 
- `${CliConfig.cwd}` 在 `@prompt` 装饰器中是编译时插值
- 编译时的 `CliConfig.cwd` 是编译时的当前目录，不是运行时的workspace
- Agent看到的示例路径是编译时的路径

### 问题2: FileSearchAgent和CodeSearchAgent也有同样问题 ❌

**文件**: `src/core/agents/subagents/explorer_agent.cj:245, 249, 259, 292`

```cangjie
- Search the project rooted at **${CliConfig.cwd}**.  // ❌ 编译时插值
1. **Absolute paths only.** Combine ${CliConfig.cwd} with relative segments...  // ❌ 编译时插值
- ${CliConfig.cwd}  // ❌ 编译时插值
- Given a pattern... find every meaningful occurrence in ${CliConfig.cwd}.  // ❌ 编译时插值
```

### 问题3: ContextOrchestrationService使用运行时插值 ✅ 但可能不够

**文件**: `src/core/services/context_orchestration_service.cj:184`

```cangjie
DirectoryAnalyzerAgent auto-run. Analyze the repository located at ${CliConfig.cwd}.
```

**分析**:
- 这里使用的是运行时插值（字符串模板），应该是正确的
- 但如果workspace没有正确设置，`CliConfig.cwd` 可能还是默认值

### 问题4: Shell命令执行的工作目录 ✅ 正确

**文件**: `src/app/process_input.cj:36`

```cangjie
let (exitCode, stdOutData, stdErrData) = ShellUtils.execute([command], workDir: CliConfig.cwd)
```

**分析**:
- Shell命令执行时使用了 `CliConfig.cwd` 作为工作目录
- 如果workspace正确设置，这应该是正确的

---

## 🎯 根本原因

### 主要原因

1. **SubAgent Prompt中的编译时插值**: DirectoryAnalyzerAgent、FileSearchAgent、CodeSearchAgent的prompt中使用了 `${CliConfig.cwd}`，这是编译时插值，导致Agent看到的示例路径是编译时的路径

2. **路径传递依赖字符串解析**: 虽然ContextOrchestrationService在question中传递了workspace路径，但SubAgent的prompt中的示例使用了编译时的路径，可能误导Agent

3. **可能workspace没有正确设置**: 需要验证参数解析是否真的生效

---

## ✅ 修复方案

### 修复1: 移除SubAgent Prompt中的编译时插值

**文件**: `src/core/agents/subagents/explorer_agent.cj`

**修改**: 将所有 `${CliConfig.cwd}` 改为说明性文本，让Agent从question中提取路径

```cangjie
// 修改前
- Map the high-level structure of the project at **${CliConfig.cwd}**.
1. Start with `listDirectory("${CliConfig.cwd}")`, then dive into key folders.

// 修改后
- Map the high-level structure of the project. The project path will be provided in the question.
1. Extract the project path from the question (format: "Analyze the repository located at /path/to/project").
2. Start with `listDirectory("/path/to/project")`, then dive into key folders.
```

### 修复2: 增强ContextOrchestrationService的路径传递

**文件**: `src/core/services/context_orchestration_service.cj`

**修改**: 确保传递的路径是绝对路径，并且格式明确

```cangjie
// 修改前
DirectoryAnalyzerAgent auto-run. Analyze the repository located at ${CliConfig.cwd}.

// 修改后
DirectoryAnalyzerAgent auto-run. Analyze the repository located at ${CliConfig.cwd.toString()}.

IMPORTANT: The project path is: ${CliConfig.cwd.toString()}
Use this exact path for all file operations. All paths must be absolute.
```

### 修复3: 验证workspace设置

添加更详细的日志，验证workspace是否正确设置：

```cangjie
// 在setWorkspace后
LogUtils.info("[CliConfig] Workspace set to: ${absPath}")
LogUtils.info("[CliConfig] Workspace exists: ${exists(absPath)}")
LogUtils.info("[CliConfig] Workspace is directory: ${try { let _ = Directory.readFrom(absPath); true } catch { false }}")
```

---

## 🧪 验证步骤

### 步骤1: 验证参数解析

运行命令并查看日志：
```bash
cjpm run --name codelin --run-args "-w trader"
```

查看日志：
```bash
cat .codelin/codelin.log | grep -E "\[parseArgs\]|\[CliConfig\]|\[main\]" | grep -i workspace
```

应该看到：
```
[parseArgs] Setting workspace from -w: trader
[CliConfig] Workspace set to: /absolute/path/to/trader
[main] Workspace set to: /absolute/path/to/trader
```

### 步骤2: 验证Agent Prompt

检查Agent prompt中的路径：
- 应该看到运行时的workspace路径，而不是编译时的路径

### 步骤3: 验证Shell命令

检查Shell命令执行的工作目录：
- `pwd` 应该显示trader目录的绝对路径
- `ls -la` 应该显示trader目录的内容

---

## 📝 待修复文件列表

1. **`src/core/agents/subagents/explorer_agent.cj`**
   - FileSearchAgent prompt (第245, 249, 259行)
   - CodeSearchAgent prompt (第292行)
   - DirectoryAnalyzerAgent prompt (第341, 346行)

2. **`src/core/services/context_orchestration_service.cj`**
   - 增强路径传递格式（第170, 184, 198, 212, 227行）

3. **`src/core/config/cli_config.cj`**
   - 增强workspace设置日志（第181行）

---

**分析完成时间**: 2025-01-XX  
**下一步**: 实施修复

