# CodeLin 综合说明

> 状态：2025-11-26 · 作者：AI 助手  
> 目标：快速了解 CodeLin 的架构、当前能力、正在进行的 UI/函数式改造，以及需要关注的风险与后续工作。

---

## 1. 项目快照

| 维度 | 说明 |
| --- | --- |
| 主语言 | 仓颉（Cangjie） |
| 构建 | `cjpm build` |
| 测试 | `cjpm test`（目前因 `std.test` 未添加到 `cjpm.toml` 而无法运行，需手动补充依赖） |
| 入口 | `src/app/cli_app.cj`（事件驱动的 CLI 应用） |
| 关键文档 | `FUNCTIONAL_ARCHITECTURE_DESIGN.md`、`ui1.md`、`codelin12.md` |

---

## 2. 架构概览

### 2.1 层次

1. **应用层** (`src/app/cli_app.cj`)  
   - 通过 `EventHandlerManager` 订阅 Chat/SubAgent 事件，协调 UI、日志和执行状态。  
   - 新增 `StatusBar` 集成，实时展示当前操作、进度、耗时与连接状态。

2. **核心服务层** (`src/core/services/*`)  
   - `ContextOrchestrationService`：聚合上下文、过滤候选。  
   - `ParallelAgentExecutor`：批量并发执行工具/子 Agent。  
   - `CodeQualityToolset`：代码质量与异味分析（已函数式化）。

3. **Agent/工具层** (`src/core/agents`, `src/core/tools`)  
   - SubAgent 体系（Planner/Explorer/Editor/Reviewer 等）通过 `AgentAsTool` 暴露。  
   - 工具接口遵循 `magic` 框架协议，统一事件和上下文管理。

4. **I/O 与 UI 层** (`src/io/*`)  
   - `print_utils.cj`：ANSI 颜色、进度条、工具输出摘要等。  
   - `status_bar.cj`：底部状态栏，提供操作/进度/耗时/状态提示。  
   - `status_bar_test.cj`、`print_utils_ui_test.cj`：覆盖 UI 组件的行为。

### 2.2 数据流（简化）

```
用户输入 → cli_app (事件注册) → Agent/工具执行
  ↘ PrintUtils / StatusBar 更新
    ↘ Context/File/Cache 组件维护状态
```

---

## 3. 函数式编程改造

| 模块 | 改造内容 |
| --- | --- |
| `src/core/utils/functional_utils.cj` | 引入 `Result<T,E>`、`filter/map/fold/collectIteratorToArrayList` 等组合器，提供 `andThen/ orElse/ when`。 |
| `context_orchestration_service.cj` | 由 `map/fold/find` 驱动上下文拼装，减少可变状态。 |
| `process_input.cj` | 使用迭代器链处理文件引用。 |
| `code_quality_toolset.cj` | 使用 `FunctionalUtils.groupBy/fold/when` 生成诊断。 |
| `parallel_agent_executor.cj` | `collectIteratorToArrayList` + `filterMap` 处理结果，`fold` 聚合 Future。 |

测试覆盖：`functional_utils_test.cj`、`parallel_agent_executor_test.cj`。  
设计文档：`FUNCTIONAL_ARCHITECTURE_DESIGN.md` 给出分层/状态管理/纯函数策略。

---

## 4. TUI & 交互体验

### 4.1 已完成能力

- `printProgress/clearProgress`：30 字符宽度进度条，支持标签、百分比。  
- `formatDuration/printExecutionTime`：ms/s/m 智能格式化。  
- `printToolWithParams`：按 Claude Code 风格显示工具参数，并自动截断长值。  
- `printToolOutputSummary`：长输出展示前几行并标注截断。  
- `StatusBar`：显示当前操作、完成度、耗时、连接状态、快捷键提示。  
- `cli_app` 集成：在 ChatModel/SubAgent 事件中更新状态栏、进度和耗时。

### 4.2 规划 & 进度 (`ui1.md`)

| Phase | 描述 | 进度 |
| --- | --- | --- |
| P1 执行信息增强 | 进度条 + 耗时统计 + 指标 | 66%（指标收集未完成） |
| P2 SubAgent 详细视图 | ALT 缓冲区、滚动、实时刷新 | 0%（待实现） |
| P3 状态栏 | StatusBar + 自动更新 | 60%（与事件系统部分联动，待终端尺寸探测/自动刷新） |
| P4 工具调用增强 | 参数预览 + 执行时间 + 输出摘要 | 40%（执行时间/事件挂钩待实现） |
| P5/P6 流式输出 + 快捷键 | 缓冲渲染/KeyboardHandler | 0% |

参照文档 `ui1.md` 获取全部验收标准与时间表。

---

## 5. 上下文与缓存系统

### FileManager (`src/core/context/components/file_manager.cj`)

- 读写职责：封装磁盘 `readFile/writeFile`，提供缓存（HashMap）与统计。  
- 支持大文件检测 (`processLargeFile`)，通过估算 token 数自动截断。  
- 统计结构 `FileManagerStats` 记录读取次数、token 总量、缓存尺寸。  
- 依赖 `Cl100kTokenizer` 提供更准确 token 估算；若缺失使用启发式。

### CacheManager (`src/core/context/components/cache_manager.cj`)

- Token 上限/使用量跟踪，ReadWriteLock 确保并行读写。  
- GC 策略结合 LRU、相关性和时间衰减；记录 GC 释放统计。  
- 近期需要修复：`System.currentTimeMillis()` → `DateTime` 的封装函数（当前编译报错）。可改写为 `DateTime.now().toUnixTimeStamp().toMilliseconds()` 或 `TimeUtils.nowMillis()`（若有）。  
- 日志依赖 `LogUtils` 已在文件中引用。

> **注意**：仓库当前 `cache_manager.cj` 使用 `System.*`/`LogUtils` API，但并未在顶部导入对应模块，需要对照最新 `magic`/`std` 包进行修正。

---

## 6. 构建 & 测试

1. **编译**  
   ```bash
   cjpm build
   ```
   - 常见错误：`System.currentTimeMillis`、`HashMap.set` 等来自旧实现的符号需替换。

2. **测试**  
   - 需要在 `cjpm.toml` 的 `[dependencies]` 中补充 `std.test = "*"`。  
   - 重新执行：  
     ```bash
     cjpm test
     ```
   - 当前新增的 UI/StatusBar 测试 (`print_utils_ui_test.cj`, `status_bar_test.cj`) 依赖此配置。

---

## 7. 未决事项 & 风险

| 事项 | 状态/风险 |
| --- | --- |
| `std.test` 依赖 | 被移除，导致 `cjpm test` 无法运行；需确认最终策略并更新 `cjpm.toml`。 |
| `cache_manager.cj` | 使用了 `System.*` 及默认参数语法，未经适配 Cangjie 1.0（`param!: Type = default`）；需统一改写。 |
| 状态栏终端尺寸 | 目前硬编码 80 列，建议接入终端尺寸检测/ALT 缓冲区能力。 |
| 工具执行时间统计 | 仅在 SubAgent 层展示，工具调用（Phase 4.2）尚未记录执行耗时。 |
| 性能指标 | Phase 1.3 的 `PerformanceMetrics` 尚未实现，UI 无法展示 Token/API 统计。 |

---

## 8. 推荐阅读顺序

1. `codelin12.md`：函数式改造总体日志。  
2. `FUNCTIONAL_ARCHITECTURE_DESIGN.md`：架构蓝图与阶段拆解。  
3. `ui1.md`：参考 Claude Code 的 TUI 改造方案。  
4. `src/app/cli_app.cj`：事件注册、UI 输出入口。  
5. `src/core/utils/functional_utils.cj`：函数式工具链，实现细节。  
6. `src/io/print_utils.cj` + `src/io/status_bar.cj`：当前 UI 能力。  
7. `src/core/context/components/*`：FileManager/CacheManager 负责的上下文生命周期。

---

## 9. 下一步建议

1. **恢复并固定测试依赖**：在 `cjpm.toml` 中重新加入 `std.test`，并确保 CI 运行 `cjpm test`。  
2. **修复 `cache_manager.cj`**：替换 `System.*`/默认参数语法，补充引入；确保 `cjpm build` 通过。  
3. **完成 UI Phase 1.3 + Phase 4.2**：采集 Token/API Metrics、记录工具耗时，与状态栏/工具日志联动。  
4. **实现 SubAgent 全屏视图 (Phase 2)**：参考 `ui1.md` 实现 ALT 缓冲区与滚动。  
5. **整理文档索引**：将本 `codelinx.md` 与既有文档（`codelin12.md` 等）互相引用，方便协作者快速定位。

---

如需进一步的模块级深挖或迁移指导，可参考对应文档并结合最新代码检索。该说明将随着 UI/函数式改造推进同步更新。打印完成 ✅

