# LSP线程安全修复 - CLI验证指南

## 📋 验证目的

验证LSP线程安全修复是否解决了并行查询死锁问题。

---

## 🎯 测试场景

### 场景1: 并行LSP符号查询（主要测试）

**目标**: 验证`getMultipleFileSymbols`不再卡死，能成功处理所有文件

**修复前症状**:
```
✅ 成功获取第1个文件 (src/main.cj)
❌ [卡住] 后续3个文件永不完成
```

**修复后预期**:
```
✅ 批次1完成: 4个文件
✅ 批次2完成: 2个文件
⚡ 并行查询完成: 6/6文件，共128个符号
```

---

## 🚀 执行步骤

### Step 1: 启动CLI

在新的终端窗口中：

```bash
cd /Users/louloulin/Documents/linchong/cjproject/codelin
cjpm run --name cli
```

### Step 2: 输入测试命令

等待CLI启动后，输入以下命令：

```
使用getMultipleFileSymbols工具并行获取以下6个文件的符号信息，并告诉我总耗时和符号数量：/Users/louloulin/Documents/linchong/cjproject/codelin/src/main.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/guideline.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/parse_args.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/app/cli_app.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/app/cancel_checker.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/io/colors.cj
```

### Step 3: 观察执行

**关键观察点**:

1. **不再卡死** - 所有6个文件都能成功处理
2. **总耗时合理** - 预期 ~1-2秒（串行LSP请求）
3. **返回完整结果** - 包含所有文件的符号信息

### Step 4: 查看日志

在另一个终端窗口中：

```bash
tail -f /Users/louloulin/Documents/linchong/cjproject/codelin/.codelin/abc.log | grep -E "(批次|完成|卡住|获取到)"
```

**预期日志输出**:

```
📦 批量获取 6 个文件的符号信息...
🔄 并行处理批次: 0 - 3
⚡ 获取到 1 个符号: /Users/.../src/main.cj
⚡ 获取到 8 个符号: /Users/.../src/guideline.cj
⚡ 获取到 3 个符号: /Users/.../src/parse_args.cj
⚡ 获取到 15 个符号: /Users/.../src/app/cli_app.cj
🔄 并行处理批次: 4 - 5
⚡ 获取到 2 个符号: /Users/.../src/app/cancel_checker.cj
⚡ 获取到 5 个符号: /Users/.../src/io/colors.cj
⚡ 并行查询完成: 6/6 文件，共 34 个符号，耗时 1200ms
```

---

## ✅ 验收标准

| 指标 | 修复前 | 修复后目标 | 说明 |
|------|--------|-----------|------|
| **完成文件数** | 1/6 ❌ | 6/6 ✅ | 不再卡死 |
| **总耗时** | N/A (超时) | 1-2秒 | 串行LSP请求 |
| **返回结果** | 不完整 | 完整JSON | 包含所有文件 |
| **符号总数** | N/A | ~30-50个 | 取决于文件内容 |

### 成功标准

- ✅ **所有6个文件都成功处理**
- ✅ **返回JSON格式结果**
- ✅ **日志显示"并行查询完成"**
- ✅ **总耗时 < 5秒**

### 失败标准

- ❌ 只处理了1个文件就卡住
- ❌ 超过10秒没有响应
- ❌ 返回错误信息

---

## 🔍 问题排查

### 如果仍然卡住

1. **检查日志最后一行**:
   ```bash
   tail -10 /Users/louloulin/Documents/linchong/cjproject/codelin/.codelin/abc.log
   ```

2. **查看卡在哪个文件**:
   ```bash
   grep "获取到.*个符号" /Users/louloulin/Documents/linchong/cjproject/codelin/.codelin/abc.log | tail -5
   ```

3. **检查是否有异常**:
   ```bash
   grep -i "error\|exception\|failed" /Users/louloulin/Documents/linchong/cjproject/codelin/.codelin/abc.log | tail -10
   ```

### 如果出现错误

请提供以下信息：
1. 日志文件最后50行
2. 错误发生时正在处理的文件
3. 终端输出的错误信息

---

## 📊 性能对比

### 修复前（死锁）

```
Timeline:
0ms    - 开始处理
150ms  - ✅ 第1个文件完成
150ms+ - ❌ 卡住，永不完成
```

### 修复后（线程安全）

```
Timeline:
0ms    - 开始处理
150ms  - ✅ 第1个文件完成
300ms  - ✅ 第2个文件完成
450ms  - ✅ 第3个文件完成
600ms  - ✅ 第4个文件完成
750ms  - ✅ 第5个文件完成
900ms  - ✅ 第6个文件完成
900ms  - ⚡ 全部完成！
```

**说明**: 虽然LSP请求是串行的（受互斥锁保护），但**不再死锁**，功能可用。

---

## 🎉 验证成功后

请告诉我：
1. ✅ 是否所有6个文件都成功处理？
2. ✅ 总耗时是多少？
3. ✅ 返回的符号总数是多少？

我会更新`tool1.md`，标记CLI验证完成！

---

## 📝 备选测试命令

### 简化版（4个文件）

```
使用getMultipleFileSymbols工具获取以下4个文件的符号：/Users/louloulin/Documents/linchong/cjproject/codelin/src/main.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/guideline.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/parse_args.cj,/Users/louloulin/Documents/linchong/cjproject/codelin/src/app/cli_app.cj
```

### 测试缓存功能（配合测试）

```
使用readFile读取/Users/louloulin/Documents/linchong/cjproject/codelin/src/main.cj文件
```

然后再次：
```
使用readFile再次读取/Users/louloulin/Documents/linchong/cjproject/codelin/src/main.cj文件
```

观察日志中的"Cache HIT"标记。

---

**创建时间**: 2024-10-26  
**文档版本**: v1.0  
**对应修复**: LSP_THREAD_SAFETY_FIX_REPORT.md

