# macOS 动态库加载问题修复指南

## 问题描述

运行编译后的 `cli` 二进制文件时出现错误：
```
dyld[769]: Library not loaded: @rpath/libstdx.encoding.json.dylib
```

这是因为 macOS 无法找到 Cangjie 运行时所需的动态库。

## 解决方案

### 方案一：使用项目提供的启动脚本（推荐）

项目已经提供了配置好环境的启动脚本：

```bash
# 1. 确保脚本有执行权限
chmod +x /Users/louloulin/Documents/linchong/cjproject/codelin/scripts/magic-cli.sh

# 2. 直接使用脚本启动
/Users/louloulin/Documents/linchong/cjproject/codelin/scripts/magic-cli.sh
```

### 方案二：配置环境变量

如果需要在当前终端会话中直接运行，需要设置以下环境变量：

```bash
# 1. 设置 CANGJIE_HOME（如果还没设置）
export CANGJIE_HOME="/Users/louloulin/Documents/linchong/cj/CangjieSDK-Darwin"
source $CANGJIE_HOME/envsetup.sh

# 2. 设置 MAGIC_PATH（如果还没设置）
export MAGIC_PATH="/path/to/CangjieMagic"

# 3. 设置动态库路径
export DYLD_LIBRARY_PATH="/Users/louloulin/Documents/linchong/cjproject/codelin/target/release/cli:\
/Users/louloulin/Documents/linchong/cjproject/codelin/target/release/magic:\
/Users/louloulin/Documents/linchong/cjproject/codelin/ffi:\
${MAGIC_PATH}/libs/cangjie-stdx-mac-aarch64-1.0.0.1/darwin_aarch64_llvm/dynamic/stdx:\
${DYLD_LIBRARY_PATH}"

# 4. 运行程序
/Users/louloulin/Documents/linchong/cjproject/codelin/target/release/bin/cli
```

### 方案三：创建便捷启动别名（推荐长期使用）

在您的 `~/.zshrc` 文件中添加以下内容：

```bash
# 添加到 ~/.zshrc
alias codelin='/Users/louloulin/Documents/linchong/cjproject/codelin/scripts/magic-cli.sh'
```

然后重新加载配置：
```bash
source ~/.zshrc
```

之后就可以在任何目录直接使用 `codelin` 命令了。

### 方案四：使用 cjpm 运行（开发阶段）

在项目目录内使用 cjpm：

```bash
cd /Users/louloulin/Documents/linchong/cjproject/codelin
cjpm run --name cli
```

## 环境变量检查清单

运行前请确保以下环境变量已正确设置：

```bash
# 检查环境变量
echo "CANGJIE_HOME: $CANGJIE_HOME"
echo "MAGIC_PATH: $MAGIC_PATH"
echo "DYLD_LIBRARY_PATH: $DYLD_LIBRARY_PATH"

# 检查关键动态库是否存在
ls -l ${MAGIC_PATH}/libs/cangjie-stdx-mac-aarch64-*/darwin_aarch64_llvm/dynamic/stdx/libstdx.encoding.json.dylib
```

## 永久性配置（推荐）

为了避免每次都要手动设置，建议在 `~/.zshrc` 中添加：

```bash
# Cangjie 开发环境配置
export CANGJIE_HOME="/Users/louloulin/Documents/linchong/cj/CangjieSDK-Darwin"
source $CANGJIE_HOME/envsetup.sh 2>/dev/null || true

# Magic 路径配置
export MAGIC_PATH="/path/to/your/CangjieMagic"  # 请替换为实际路径

# CodeLin 便捷命令
alias codelin='/Users/louloulin/Documents/linchong/cjproject/codelin/scripts/magic-cli.sh'
```

保存后执行：
```bash
source ~/.zshrc
```

## 验证安装

运行以下命令验证配置是否成功：

```bash
# 使用脚本启动（推荐）
/Users/louloulin/Documents/linchong/cjproject/codelin/scripts/magic-cli.sh --help

# 或使用别名（如果已配置）
codelin --help
```

如果看到程序的帮助信息，说明配置成功！

## 常见问题

### Q: 提示 "MAGIC_PATH is not set"
A: 需要先设置 MAGIC_PATH 环境变量：
```bash
export MAGIC_PATH="/path/to/CangjieMagic"
```

### Q: 提示 "CANGJIE_HOME is not set"
A: 需要设置 CANGJIE_HOME 并加载环境：
```bash
export CANGJIE_HOME="/path/to/CangjieSDK-Darwin"
source $CANGJIE_HOME/envsetup.sh
```

### Q: 还是找不到动态库
A: 检查 MAGIC_PATH 下是否有对应的 stdx 库：
```bash
find $MAGIC_PATH -name "libstdx.encoding.json.dylib"
```

## 相关文件

- 启动脚本: `scripts/magic-cli.sh`
- 项目配置: `cjpm.toml`
- 环境配置示例: `.env.example`
- 主程序: `target/release/bin/cli`

