# MCP 工具使用问题修复报告

## 问题描述

用户输入"通过agentmem搜索林"，但 Agent 执行的是普通的 `grepSearch`，而不是使用 agentmem MCP 服务器的 `agentmem_search_memories` 工具。

## 问题分析

### 1. agentmem 已成功加载 ✅

从日志分析（`.codelin/codelin.log`）：
- ✅ 第16行：`Successfully parsed config for: agentmem`
- ✅ 第62-63行：创建了 Stdio MCP client
- ✅ 第69行：`Successfully loaded MCP server: agentmem`
- ✅ 第94行：收到了 agentmem 的5个工具：
  - `agentmem_search_memories` - 在 AgentMem 系统中搜索相关记忆
  - `agentmem_list_agents` - 列出AgentMem系统中所有可用的Agent
  - `agentmem_add_memory` - 添加一条新的记忆到 AgentMem 系统中
  - `agentmem_get_system_prompt` - 获取基于用户记忆的系统提示词
  - `agentmem_chat` - 与 AgentMem 进行智能对话，基于记忆上下文生成回复

### 2. Agent 没有使用 MCP 工具 ❌

从日志第299-313行可以看到：
```json
{
  "name": "grepSearch",
  "arguments": {
    "pattern": "林",
    "path": "/Users/louloulin/Documents/linchong/gitcode/magic/codelin",
    "include": "*"
  }
}
```

Agent 选择了 `grepSearch` 而不是 `agentmem_search_memories`。

### 3. 根本原因

**Agent 的 prompt 中没有关于 MCP 工具的说明**：
- `CodeLinCangjieAgent` 的 prompt 只提到了 Cangjie 开发相关的内容
- 没有说明如何使用 MCP 工具
- 没有说明当用户提到特定 MCP 服务器时应该使用哪个工具
- Agent 不知道 `agentmem_search_memories` 的存在或用途

## 解决方案

### 在 Agent Prompt 中添加 MCP 工具说明

已在 `src/core/agents/cangjie_code_agent.cj` 的 prompt 末尾添加：

```cangjie
## MCP (Model Context Protocol) Tools

You have access to MCP tools from external servers that extend your capabilities:

**AgentMem MCP Server** - Memory and Agent Management:
- `agentmem_search_memories`: Search for memories in the AgentMem system. Use this when the user asks to search memories or mentions "agentmem" or "记忆".
- `agentmem_list_agents`: List all available agents in the AgentMem system.
- `agentmem_add_memory`: Add a new memory to the AgentMem system.
- `agentmem_get_system_prompt`: Get system prompt based on user memories.
- `agentmem_chat`: Have an intelligent conversation with AgentMem based on memory context.

**Important**: When the user explicitly mentions a specific MCP server (e.g., "通过agentmem搜索" or "use agentmem to search"), you MUST use the corresponding MCP tool instead of regular tools. For example:
- User says "通过agentmem搜索X" → Use `agentmem_search_memories` with query="X"
- User says "use agentmem to search for Y" → Use `agentmem_search_memories` with query="Y"
- User mentions "记忆" or "memory" in context of AgentMem → Use AgentMem tools

Other MCP servers (Context7, Sequential Thinking, Playwright, Mastra) also provide specialized tools. Check available tools and use them when appropriate.
```

## 验证步骤

1. **重新编译**：
   ```bash
   cjpm build
   ```

2. **重启 CodeLin**：
   ```bash
   cjpm run --name cli
   ```

3. **测试 agentmem 工具**：
   - 输入："通过agentmem搜索林"
   - 应该看到 Agent 使用 `agentmem_search_memories` 工具
   - 日志中应该显示：`📦 MCP Server: agentmem | 🔧 agentmem_search_memories`

4. **检查日志**：
   ```bash
   tail -100 .codelin/codelin.log | grep -i "agentmem_search"
   ```

## 预期行为

修复后，当用户输入"通过agentmem搜索X"时：
1. Agent 应该识别到用户想要使用 agentmem
2. Agent 应该选择 `agentmem_search_memories` 工具
3. Agent 应该传递正确的参数：`{"query": "X", "user_id": "..."}`
4. 日志中应该显示 MCP 工具调用信息

## 其他 MCP 服务器

同样的逻辑适用于其他 MCP 服务器：
- **Context7**: 文档查询工具
- **Sequential Thinking**: 顺序思考工具
- **Playwright**: 浏览器自动化工具
- **Mastra**: Mastra 文档工具

Agent 现在知道这些工具的存在，并会在适当的时候使用它们。

## 状态

- ✅ 已修复 Agent prompt
- ✅ 已编译通过
- ⏳ 等待用户测试验证

