# 📖 如何使用 Resume Mode (-r)

**功能**: Claude Code 风格的交互式 session 选择器  
**状态**: ✅ 100% 完成，Ready to use  
**版本**: Phase 5.2

---

## 🚀 快速开始

### 基本用法

```bash
# 方式1: 使用短参数（推荐）
cjpm run --name cli -- -r

# 方式2: 使用长参数
cjpm run --name cli -- --resume
```

---

## 💡 使用场景

### 场景 1: 恢复上次的工作

```bash
# 1. 之前工作中创建了一些 sessions
$ cjpm run --name cli
 > /rename Implement User Auth
 > ... 做了一些工作 ...
 > /exit

# 2. 今天继续工作，使用 -r 恢复
$ cjpm run --name cli -- -r

# 3. 会看到交互式选择器
Select a session to resume

   Modified       Created        # Messages   Git Branch    Summary
──────────────────────────────────────────────────────────────────────
▶  2 hours ago   6 days ago     15           feature-auth  Implement User Auth
   3 days ago    1 week ago     45           main          Fix Bug #123

↑↓/jk: navigate  │  Enter: select  │  Esc/q: cancel

# 4. 按 Enter 选择，自动加载并继续
```

### 场景 2: 在多个项目间切换

```bash
# 项目 A 的工作
$ cd /path/to/project-a
$ cjpm run --name cli
 > /rename Project A - API Development
 > ... 工作 ...
 > /exit

# 项目 B 的工作
$ cd /path/to/project-b
$ cjpm run --name cli
 > /rename Project B - Bug Fixes
 > ... 工作 ...
 > /exit

# 回到项目 A，快速恢复
$ cd /path/to/project-a
$ cjpm run --name cli -- -r
# 选择 "Project A - API Development"
```

### 场景 3: 按时间查找旧的 session

```bash
$ cjpm run --name cli -- -r

# 查看 Modified 列，快速找到最近修改的 sessions
   Modified       Created        # Messages   ...
──────────────────────────────────────────────────
▶  2 hours ago   6 days ago     15           ...  <- 最近的
   3 days ago    1 week ago     45           ...
   1 month ago   2 months ago   100          ...
```

---

## ⌨️ 键盘操作

| 按键 | 功能 | 说明 |
|------|------|------|
| `↑` | 向上移动 | 选择上一个 session |
| `↓` | 向下移动 | 选择下一个 session |
| `k` | 向上移动 | Vim 风格 |
| `j` | 向下移动 | Vim 风格 |
| `Enter` | 确认选择 | 加载选中的 session 并启动 |
| `Esc` | 取消 | 放弃选择，创建新 session |
| `q` | 取消 | 同 Esc |

---

## 📊 界面说明

### 表格列

```
   Modified         Created          # Messages   Git Branch      Summary
──────────────────────────────────────────────────────────────────────────
▶  2 hours ago     6 days ago       15           feature-x       Implement API
   ↑                ↑                ↑            ↑               ↑
   最后修改时间      创建时间          消息数        Git分支         会话标题
```

1. **Modified**: 最后修改时间（自动格式化为 "X ago"）
2. **Created**: 创建时间（自动格式化为 "X ago"）
3. **# Messages**: 这个 session 中的消息数量
4. **Git Branch**: 当前 Git 分支（如果在 Git 仓库中）
5. **Summary**: Session 标题（可通过 `/rename` 修改）

### 选择标记

- `▶` - 当前选中的 session（白色高亮）
- ` ` - 未选中的 session（灰色）

### Session Info Bottom Bar

选择 session 后，在输入框下方会显示当前 session 信息：

```
 > Your prompt here

 ┌──────────────────────────────────────────────────┐
 │ Session: feature-x | Implement API | 15 msgs | 5 files │
 └──────────────────────────────────────────────────┘
```

---

## 🎯 最佳实践

### 1. 命名 Sessions

```bash
# ❌ 不好：使用默认名称
 > ... 工作 ...
# Session 名称会是 "last-conversation" 或随机ID

# ✅ 好：使用有意义的名称
 > /rename User Auth Implementation
 > ... 工作 ...
# 使用 -r 时容易识别
```

### 2. 定期整理 Sessions

```bash
# 删除不再需要的 sessions
 > /list
 > /remove old-test-session
```

### 3. 使用 Git 分支配合

```bash
# 在不同的 Git 分支上工作时，session 会显示对应分支
$ git checkout feature-auth
$ cjpm run --name cli -- -r
# 可以看到哪些 sessions 是在 feature-auth 分支上创建的
```

---

## ❓ 常见问题

### Q: 没有看到任何 sessions 怎么办？

**A**: 第一次使用或没有创建过 sessions：

```bash
# 会看到这个提示
  No previous sessions found. Starting new session...

# 创建第一个 session
 > /rename My First Session
 > ... 做一些工作 ...
 > /exit

# 再次使用 -r 就能看到了
$ cjpm run --name cli -- -r
```

### Q: 如何退出选择器？

**A**: 按 `Esc` 或 `q` 键：

```bash
# 按 Esc 或 q 后
  Starting new session...

 Welcome to Cangjie CodeLin!
# 会创建一个新的 session
```

### Q: 时间显示不准确？

**A**: 时间是基于 session 的 `lastModified` 字段：

- 每次保存 session 时会更新
- 使用 `/rename`, `/new` 等命令会更新
- 添加消息也会更新

### Q: Git 分支显示为 "-" ？

**A**: 可能的原因：

1. 不在 Git 仓库中
2. `.git` 目录不存在
3. Detached HEAD 状态会显示 "detached"

### Q: 选择后没有加载历史对话？

**A**: 确认以下几点：

1. Session 文件存在于 `.codelin/sessions/`
2. 使用正确的 workspace（`--workspace` 参数）
3. 检查日志文件 `.codelin/codelin-cli.log`

---

## 🔧 高级使用

### 与其他参数组合

```bash
# -r 可以和其他参数组合使用
cjpm run --name cli -- --workspace /path/to/project -r

# 在特定 workspace 中恢复 session
cjpm run --name cli -- -w /path/to/project -r
```

### Session 存储位置

Sessions 存储在：

```
.codelin/
├── sessions/
│   ├── last-conversation.json
│   ├── my-session-name.json
│   └── metadata/
│       ├── last-conversation.json
│       └── my-session-name.json
└── codelin-cli.log
```

### 手动管理 Sessions

```bash
# 查看所有 sessions
ls -la .codelin/sessions/

# 备份 session
cp .codelin/sessions/my-session.json ~/backup/

# 恢复 session
cp ~/backup/my-session.json .codelin/sessions/
```

---

## 🎨 UI 自定义

Session Info Bottom Bar 的位置和样式已经优化：

- ✅ 位于输入框下方（而非左侧）
- ✅ 清晰的边框和对齐
- ✅ 紧凑的信息布局
- ✅ 颜色高亮（Cyan）

---

## 📚 相关文档

- `CLAUDE_CODE_R_IMPLEMENTATION.md` - 完整实现报告
- `QUICK_START_RESUME_MODE.md` - 快速开始
- `PHASE5_COMPLETE_SUCCESS.md` - 完成报告
- `test_resume_mode.sh` - 测试脚本

---

## 🎉 总结

Resume Mode (`-r`) 提供了：

✅ **快速恢复** - 一键回到之前的工作状态  
✅ **可视化选择** - 表格式界面，信息一目了然  
✅ **直观操作** - 箭头键/vim 键，熟悉的操作方式  
✅ **智能显示** - 自动格式化时间，显示 Git 分支  
✅ **完整信息** - Session 名称、消息数、文件数等

**立即试用**:

```bash
cjpm run --name cli -- -r
```

🚀 **Happy Coding!**

