# Phase 5 手动测试指南

本指南帮助你手动测试 Phase 5 的所有新功能。

---

## 🚀 启动 CodeLin

```bash
cd /Users/louloulin/Documents/linchong/cjproject/codelin
cjpm run --name cli
```

---

## ✅ 测试清单

### Test 1: 验证会话指示器

**目标**: 确认 CLI 提示符显示当前会话标题

**步骤**:
1. 启动 CodeLin
2. 观察提示符，应该显示：`[New Chat]  >`

**预期结果**: ✅ 提示符包含会话标题

---

### Test 2: 测试 /new 命令

**目标**: 创建新会话

**步骤**:
1. 在 CLI 中输入：`/new`
2. 观察输出

**预期结果**:
```
✨ Started new session
```

**验证**: 提示符应该显示 `[New Chat]  >`

---

### Test 3: 测试 /sessions 命令

**目标**: 查看所有会话列表

**步骤**:
1. 在 CLI 中输入：`/sessions`
2. 观察输出

**预期结果**:
```
╔══════════════════════════════════════════════════════════╗
║ 📚 Your Sessions (1)                                      ║
╟──────────────────────────────────────────────────────────╢
║ ▶ last-conversation          (Active)                    ║
║   "New Chat"                                             ║
║   💬 0 messages  📁 0 files                              ║
╚══════════════════════════════════════════════════════════╝

Commands: /new  /switch <name>  /rename <title>
```

**验证**: 
- ✅ 显示漂亮的框线格式
- ✅ 显示活动会话标记 (▶)
- ✅ 显示元数据（消息数、文件数）

---

### Test 4: 测试 /rename 命令

**目标**: 重命名当前会话

**步骤**:
1. 在 CLI 中输入：`/rename Test Session for Phase 5`
2. 观察提示符变化

**预期结果**:
```
✅ Session renamed to: "Test Session for Phase 5"
```

**验证**: 
- ✅ 提示符更新为 `[Test Session for...]  >`
- ✅ 长标题被截断

---

### Test 5: 测试会话自动命名

**目标**: AI 自动生成会话标题

**步骤**:
1. 创建新会话：`/new`
2. 发送一个简单的问题：`帮我创建一个简单的 Hello World 程序`
3. 等待 AI 回复
4. 再次查看会话列表：`/sessions`

**预期结果**:
- ✅ 会话标题应该自动更新为类似 "Create Hello World Program" 的标题
- ✅ 提示符显示新标题

**注意**: 如果 AI 生成失败，会使用 fallback（用户消息前50字符）

---

### Test 6: 测试保存和切换会话

**目标**: 保存会话并切换

**步骤**:
1. 保存当前会话：`/conversation save my-test-session`
2. 创建新会话：`/new`
3. 查看会话列表：`/sessions`
4. 切换回之前的会话：`/switch my-test-session`

**预期结果**:
```
✅ Conversation saved as 'my-test-session'
✨ Started new session
...
✅ Switched to session 'my-test-session'
```

**验证**:
- ✅ 提示符显示正确的会话标题
- ✅ 会话内容正确恢复

---

### Test 7: 测试 /help 命令

**目标**: 确认帮助文本包含新命令

**步骤**:
1. 在 CLI 中输入：`/help`
2. 查找 Phase 5 命令

**预期结果**: 帮助文本应该包含：
```
🆕 Claude Code Style Commands (Phase 5):
  /new                               - Start a new session
  /switch <name>                     - Switch to a different session
  /sessions                          - List all sessions with details
  /rename <title>                    - Rename current session
```

---

### Test 8: 测试向后兼容

**目标**: 确认旧命令仍然工作

**步骤**:
1. 测试 `/conversation list`
2. 测试 `/conversation save test-compat`
3. 测试 `/conversation resume test-compat`
4. 测试 `/conversation remove test-compat`

**预期结果**: 所有旧命令应该正常工作

---

### Test 9: 测试长标题截断

**目标**: 验证长标题在提示符中正确截断

**步骤**:
1. 创建新会话：`/new`
2. 重命名为很长的标题：`/rename This is a very long session title that should be truncated in the prompt`
3. 观察提示符

**预期结果**:
```
✅ Session renamed to: "This is a very long session title that should be truncated in the prompt"
```

**验证**: 提示符应该显示 `[This is a very lo...]  >`（截断到17个字符+...）

---

### Test 10: 测试元数据持久化

**目标**: 确认元数据正确保存到文件系统

**步骤**:
1. 创建一个会话并发送几条消息
2. 重命名会话：`/rename Persistence Test`
3. 保存会话：`/conversation save persist-test`
4. 退出 CodeLin
5. 重新启动 CodeLin
6. 切换到该会话：`/switch persist-test`
7. 查看会话列表：`/sessions`

**预期结果**:
- ✅ 会话标题保持为 "Persistence Test"
- ✅ 消息计数正确
- ✅ 会话内容完整恢复

---

## 🔍 日志分析

如果需要查看详细日志，可以检查：

```bash
# 查看 CodeLin 日志
tail -f ~/.codelin/logs/cli.log

# 查看元数据文件
ls -la ~/.codelin/sessions/metadata/
cat ~/.codelin/sessions/metadata/*.json
```

---

## ✅ 验证总结

完成以上所有测试后，你应该验证：

- [x] Test 1: 会话指示器显示正确
- [x] Test 2: /new 命令工作
- [x] Test 3: /sessions 命令显示漂亮列表
- [x] Test 4: /rename 命令工作
- [x] Test 5: 自动命名功能工作
- [x] Test 6: 会话保存和切换工作
- [x] Test 7: /help 显示新命令
- [x] Test 8: 旧命令保持兼容
- [x] Test 9: 长标题正确截断
- [x] Test 10: 元数据正确持久化

---

## 🐛 如果遇到问题

### 问题 1: 编译失败

**解决方案**:
```bash
cjpm clean
cjpm build
```

### 问题 2: 命令未找到

**检查**: 确认 `process_input.cj` 中的命令路由已正确添加

### 问题 3: 自动命名不工作

**检查**: 
1. 确认 AI 模型配置正确（`zhipuai:glm-4-flash`）
2. 查看日志是否有错误
3. Fallback 应该使用用户消息前50字符

### 问题 4: 元数据未保存

**检查**:
```bash
# 确认目录存在
mkdir -p ~/.codelin/sessions/metadata

# 检查权限
ls -la ~/.codelin/sessions/
```

---

## 📝 测试报告模板

完成测试后，可以填写：

```
Phase 5 测试报告
测试日期: [填写日期]
测试者: [填写姓名]

P0.1 Session 元数据: [✅ 通过 / ❌ 失败]
P0.2 Session 命令: [✅ 通过 / ❌ 失败]
P0.3 自动命名: [✅ 通过 / ❌ 失败]
P0.4 会话指示器: [✅ 通过 / ❌ 失败]

总体评价: [填写评价]
发现的问题: [列出问题]
建议改进: [列出建议]
```

---

**准备开始测试？运行 `cjpm run --name cli` 开始吧！** 🚀

