# @mention 功能快速参考

## 🚀 快速开始

### 使用方法
在 Codelin 中使用 `@filename` 来引用文件：

```bash
# 启动 CLI
cjpm run --name cli

# 使用示例
> Explain @src/main.cj
> What's the difference between @README.md and @CODELIN.md
> Fix the bug in @src/app/process_input.cj
```

---

## 📁 支持的格式

### ✅ 当前支持（v1.0）
- `@filename` - 引用文件（相对路径）
- `@path/to/file` - 引用子目录文件
- `@/absolute/path/file` - 引用绝对路径文件

### ⏭️ 计划支持（未来版本）
- `@file.cj:10-20` - 引用特定行范围
- `@file.cj:functionName` - 引用特定函数/类
- `@src/*.cj` - 通配符引用多个文件

---

## 💡 使用示例

### 示例 1：查看文件内容
```
User > What is in @test.txt?

📎 Referenced Files:
  • test.txt (3 lines)

Agent > 这个文件包含...
```

### 示例 2：代码解释
```
User > Explain @src/main.cj and its entry point

📎 Referenced Files:
  • src/main.cj (32 lines)

Agent > 这个文件是程序的入口点...
```

### 示例 3：多文件对比
```
User > Compare @file1.txt and @file2.txt

📎 Referenced Files:
  • file1.txt (10 lines)
  • file2.txt (15 lines)

Agent > file1.txt 和 file2.txt 的主要区别是...
```

---

## 📚 文档索引

| 文档 | 用途 |
|------|------|
| `COMPLETION_REPORT.md` | 完成报告（最完整） |
| `IMPLEMENTATION_SUMMARY.md` | 实现总结（技术细节） |
| `test_mention_feature.md` | 测试文档 |
| `plan1.md` | 总体计划（已更新完成状态） |
| `QUICK_REFERENCE.md` | 快速参考（本文档） |

---

## 🔧 技术信息

### 实现文件
- `src/core/context/mention_parser.cj` - 核心解析器
- `src/app/process_input.cj` - 集成点
- `src/core/context/mention_parser_test.cj` - 测试

### 关键类
- `MentionParser` - 主要API
- `FileMention` - 文件引用数据
- `ParseResult` - 解析结果

### 主要方法
```cangjie
// 解析输入中的 @mention
MentionParser.parse(input: String): ParseResult

// 解析文件路径
MentionParser.resolveFile(mention: String): Option<Path>

// 读取文件内容
MentionParser.readFileContent(mention: FileMention): String

// 格式化显示
MentionParser.formatMentionInfo(mention: FileMention): String
```

---

## ✅ 验证状态

- [x] 代码编译通过
- [x] 单元测试编写完成
- [x] 文档完整
- [ ] 实际运行测试（待用户验证）

---

## 🐛 已知限制

1. 暂不支持行范围 `@file:10-20`
2. 暂不支持符号引用 `@file:funcName`
3. 暂不支持通配符 `@src/*.cj`
4. 文件名中不能有空格（需用引号）

---

## 📞 问题反馈

如发现问题或有建议，请：
1. 查看 `IMPLEMENTATION_SUMMARY.md` 了解实现细节
2. 查看 `test_mention_feature.md` 了解测试用例
3. 查看 `plan1.md` 了解未来计划

---

**版本**：v1.0  
**更新时间**：2024-10-24  
**状态**：✅ 已完成

