# SubAgent功能性测试指南

**日期**: 2024-10-26  
**状态**: Week 4-5 功能验证阶段  
**目标**: 实际运行验证6个SubAgent的功能和效果

---

## 🎯 测试目标

验证6个SubAgent在实际使用中的：
1. **调用准确性** - 主Agent是否正确识别何时调用SubAgent
2. **输出质量** - SubAgent输出是否符合预期格式和内容
3. **协作效果** - 多个SubAgent能否协同完成复杂任务
4. **性能表现** - 响应时间和资源消耗
5. **错误处理** - 异常情况的处理能力

---

## 📋 测试准备

### 1. 确认环境

```bash
# 确认编译成功
cd /Users/louloulin/Documents/linchong/cjproject/codelin
cjpm build

# 确认CLI可启动
./scripts/magic-cli.sh --help
```

### 2. 准备测试项目

```bash
# 创建测试目录
mkdir -p test_project
cd test_project

# 创建简单的测试文件
cat > main.cj << 'EOF'
package test

public func add(a: Int64, b: Int64): Int64 {
    return a + b
}

public func divide(a: Int64, b: Int64): Int64 {
    if (b == 0) {
        throw Exception("Division by zero")
    }
    return a / b
}

public func main() {
    let result = add(5, 3)
    println("5 + 3 = ${result}")
}
EOF

cat > utils.cj << 'EOF'
package test

public func processData(data: String): String {
    // TODO: Add validation
    let trimmed = data.trim()
    // TODO: Add error handling
    return trimmed.toUpper()
}
EOF
```

---

## 🧪 SubAgent测试场景

### 测试1: PlannerAgent - 任务规划

**目标**: 验证PlannerAgent能否分解复杂任务

**测试命令**:
```
用户输入: "为这个项目添加单元测试功能"
```

**预期行为**:
1. ✅ 主Agent识别需要规划
2. ✅ 调用PlannerAgent
3. ✅ 显示进度: "🤔 PlannerAgent正在规划..."
4. ✅ 返回JSON格式的计划，包含：
   - summary（总结）
   - tasks（子任务列表）
   - executionOrder（执行顺序）
   - risks（风险）

**检查点**:
- [ ] SubAgent调用成功
- [ ] 返回格式正确（JSON）
- [ ] 任务分解合理
- [ ] 包含依赖关系
- [ ] 估计复杂度准确

**评分标准**:
- ⭐⭐⭐⭐⭐ 完美：计划详细，任务具体，顺序合理
- ⭐⭐⭐⭐ 良好：计划基本完整，有改进空间
- ⭐⭐⭐ 可接受：能生成计划，但不够详细
- ⭐⭐ 需改进：计划模糊，缺少关键信息
- ⭐ 失败：无法生成有效计划

---

### 测试2: ExplorerAgent - 代码探索

**目标**: 验证ExplorerAgent能否理解项目结构

**测试命令**:
```
用户输入: "探索这个项目并解释代码结构"
```

**预期行为**:
1. ✅ 主Agent识别需要探索
2. ✅ 调用ExplorerAgent
3. ✅ ExplorerAgent使用工具：
   - `listDirectory` 查看目录
   - `readFile` 或 `batchReadFiles` 读取文件
   - `grep` 查找关键模式
4. ✅ 返回Markdown格式报告，包含：
   - 项目概述
   - 架构分析
   - 关键文件说明
   - 代码约定
   - 建议

**检查点**:
- [ ] 正确识别项目类型
- [ ] 准确列出关键文件
- [ ] 理解代码结构
- [ ] 识别潜在问题
- [ ] 提供有价值建议

**评分标准**:
- ⭐⭐⭐⭐⭐ 完美：全面理解，准确分析，有洞察
- ⭐⭐⭐⭐ 良好：基本理解，分析合理
- ⭐⭐⭐ 可接受：能探索，但分析浅显
- ⭐⭐ 需改进：理解片面，分析不足
- ⭐ 失败：无法理解项目结构

---

### 测试3: EditorAgent - 精准编辑

**目标**: 验证EditorAgent能否进行精确的代码修改

**测试命令**:
```
用户输入: "在utils.cj的processData函数中添加输入验证"
```

**预期行为**:
1. ✅ 主Agent识别需要编辑
2. ✅ 调用EditorAgent
3. ✅ EditorAgent工作流程：
   - 读取utils.cj
   - 定位processData函数
   - 添加输入验证
   - 保持代码风格
4. ✅ 进行精确修改

**检查点**:
- [ ] 正确定位目标函数
- [ ] 修改精准，无多余改动
- [ ] 保持代码风格一致
- [ ] 添加的验证逻辑合理
- [ ] 没有引入语法错误

**评分标准**:
- ⭐⭐⭐⭐⭐ 完美：精准修改，逻辑完善，风格统一
- ⭐⭐⭐⭐ 良好：修改正确，风格基本一致
- ⭐⭐⭐ 可接受：能完成修改，但不够精准
- ⭐⭐ 需改进：修改范围过大或不准确
- ⭐ 失败：修改错误或破坏代码

---

### 测试4: ReviewerAgent - 代码审查

**目标**: 验证ReviewerAgent能否发现代码问题

**测试命令**:
```
用户输入: "审查utils.cj的代码质量"
```

**预期行为**:
1. ✅ 主Agent识别需要审查
2. ✅ 调用ReviewerAgent
3. ✅ ReviewerAgent检查：
   - 语法正确性
   - 逻辑合理性
   - 潜在bug
   - 安全问题
   - 性能问题
   - 最佳实践
4. ✅ 返回详细审查报告

**检查点**:
- [ ] 识别TODO注释
- [ ] 发现缺少错误处理
- [ ] 指出潜在的异常
- [ ] 提供改进建议
- [ ] 评估代码质量

**评分标准**:
- ⭐⭐⭐⭐⭐ 完美：发现所有问题，建议具体可行
- ⭐⭐⭐⭐ 良好：发现主要问题，建议合理
- ⭐⭐⭐ 可接受：能发现明显问题
- ⭐⭐ 需改进：遗漏重要问题
- ⭐ 失败：无法有效审查

---

### 测试5: TestGeneratorAgent - 测试生成

**目标**: 验证TestGeneratorAgent能否生成全面的测试

**测试命令**:
```
用户输入: "为main.cj中的add和divide函数生成测试用例"
```

**预期行为**:
1. ✅ 主Agent识别需要生成测试
2. ✅ 调用TestGeneratorAgent
3. ✅ TestGeneratorAgent分析函数：
   - 理解函数签名
   - 识别输入输出
   - 考虑边界条件
   - 识别错误情况
4. ✅ 生成完整测试文件

**检查点**:
- [ ] 包含Happy Path测试
- [ ] 包含Edge Case测试
- [ ] 包含Error Case测试
- [ ] 测试命名清晰
- [ ] 断言完整

**预期测试场景**:
```cangjie
// add函数测试
- test_add_positive_numbers() // 正数相加
- test_add_negative_numbers() // 负数相加
- test_add_zero()             // 加零
- test_add_large_numbers()    // 大数相加

// divide函数测试
- test_divide_normal()        // 正常除法
- test_divide_by_zero()       // 除零异常
- test_divide_negative()      // 负数除法
```

**评分标准**:
- ⭐⭐⭐⭐⭐ 完美：覆盖全面，测试清晰，可运行
- ⭐⭐⭐⭐ 良好：覆盖主要场景，测试合理
- ⭐⭐⭐ 可接受：能生成基本测试
- ⭐⭐ 需改进：测试不完整或不清晰
- ⭐ 失败：无法生成有效测试

---

### 测试6: RefactoringAgent - 重构建议

**目标**: 验证RefactoringAgent能否识别代码问题并提供改进建议

**测试命令**:
```
用户输入: "分析utils.cj的重构机会"
```

**预期行为**:
1. ✅ 主Agent识别需要重构分析
2. ✅ 调用RefactoringAgent
3. ✅ RefactoringAgent分析：
   - 识别code smells
   - 评估代码复杂度
   - 发现重复代码
   - 评估可维护性
4. ✅ 提供具体重构建议

**检查点**:
- [ ] 识别TODO（未完成功能）
- [ ] 发现缺少错误处理
- [ ] 建议提取常量或函数
- [ ] 提供before/after示例
- [ ] 评估重构风险

**预期建议**:
- 🟡 中优先级：添加输入验证
- 🟡 中优先级：添加错误处理
- 🟢 低优先级：添加文档注释

**评分标准**:
- ⭐⭐⭐⭐⭐ 完美：准确识别问题，建议具体可行
- ⭐⭐⭐⭐ 良好：识别主要问题，建议合理
- ⭐⭐⭐ 可接受：能发现明显问题
- ⭐⭐ 需改进：分析不够深入
- ⭐ 失败：无法提供有价值建议

---

### 测试7: 多SubAgent协作

**目标**: 验证多个SubAgent能否协同工作

**测试命令**:
```
用户输入: "为这个项目添加配置管理功能，包括实现、测试和文档"
```

**预期协作流程**:
1. ✅ **PlannerAgent**: 创建实施计划
   ```json
   {
     "tasks": [
       {"id": "t1", "description": "探索现有结构"},
       {"id": "t2", "description": "设计配置管理模块"},
       {"id": "t3", "description": "实现配置类"},
       {"id": "t4", "description": "生成测试用例"},
       {"id": "t5", "description": "代码审查"}
     ]
   }
   ```

2. ✅ **ExplorerAgent**: 理解现有代码结构
   
3. ✅ **EditorAgent**: 实现配置管理功能
   
4. ✅ **TestGeneratorAgent**: 生成测试用例
   
5. ✅ **ReviewerAgent**: 审查实现质量

**检查点**:
- [ ] 主Agent自动编排SubAgent调用顺序
- [ ] 各SubAgent顺序执行
- [ ] 后续SubAgent利用前面的输出
- [ ] 最终交付完整功能
- [ ] 过程透明，有进度提示

**评分标准**:
- ⭐⭐⭐⭐⭐ 完美：自动协作，流程顺畅，结果优秀
- ⭐⭐⭐⭐ 良好：能协作，流程合理，结果满意
- ⭐⭐⭐ 可接受：基本协作，有改进空间
- ⭐⭐ 需改进：协作混乱，效果不佳
- ⭐ 失败：无法协作完成任务

---

## 📊 测试记录表

### 基础功能测试

| SubAgent | 测试场景 | 调用成功 | 输出格式 | 内容质量 | 评分 | 备注 |
|----------|---------|---------|---------|---------|------|------|
| PlannerAgent | 任务规划 | ☐ | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |
| ExplorerAgent | 代码探索 | ☐ | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |
| EditorAgent | 精准编辑 | ☐ | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |
| ReviewerAgent | 代码审查 | ☐ | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |
| TestGeneratorAgent | 测试生成 | ☐ | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |
| RefactoringAgent | 重构建议 | ☐ | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |

### 协作测试

| 场景 | SubAgent组合 | 协作顺畅 | 结果质量 | 评分 | 备注 |
|------|-------------|---------|---------|------|------|
| 复杂任务 | Planner→Explorer→Editor→Reviewer | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |
| 测试覆盖 | Explorer→TestGenerator→Reviewer | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |
| 代码改进 | Refactoring→Planner→Editor | ☐ | ☐ | ⭐⭐⭐⭐⭐ | |

### 性能测试

| 指标 | 目标 | 实际 | 状态 | 备注 |
|------|------|------|------|------|
| 单次调用延迟 | <5s | __ | ☐ | SubAgent响应时间 |
| 复杂任务总时长 | <30s | __ | ☐ | 多SubAgent协作 |
| 主Agent识别准确率 | >80% | __% | ☐ | 正确调用SubAgent的比例 |
| SubAgent输出有效率 | >90% | __% | ☐ | 输出符合预期的比例 |

---

## 🔧 调试和优化

### 常见问题

#### 问题1: SubAgent未被调用

**现象**: 主Agent直接处理，没有调用SubAgent

**可能原因**:
1. Prompt引导不够明确
2. 任务太简单，主Agent认为不需要
3. SubAgent工具未正确注册

**解决方案**:
```bash
# 1. 检查SubAgent是否正确集成
grep -n "AgentAsTool" src/app/cli_app.cj

# 2. 增强Prompt中的SubAgent使用指导
# 3. 使用更明确的提示词，如："请使用PlannerAgent创建计划"
```

#### 问题2: SubAgent输出格式不正确

**现象**: 返回非结构化文本，而非JSON/Markdown

**可能原因**:
1. SubAgent Prompt中的格式说明不够清晰
2. LLM未理解输出要求

**解决方案**:
```bash
# 优化SubAgent Prompt，强调输出格式
# 在Prompt中添加更多示例
```

#### 问题3: 响应时间过长

**现象**: 单次调用超过10秒

**可能原因**:
1. SubAgent Prompt过长
2. 模型响应慢
3. 工具调用过多

**解决方案**:
```bash
# 1. 测量各部分耗时
# 2. 考虑使用更快的模型（Claude Haiku）
# 3. 优化工具调用策略
```

### 性能优化建议

1. **SubAgent模型选择**:
   ```cangjie
   // 主Agent: 使用强大模型
   model: "claude-sonnet-4"
   
   // SubAgent: 可以使用快速模型
   model: "claude-haiku" // 速度快3倍，成本低10倍
   ```

2. **并行调用**（适用于信息收集场景）:
   ```cangjie
   // 例如：同时探索多个模块
   spawn { result1 = ExplorerAgent.chat("探索模块A") }
   spawn { result2 = ExplorerAgent.chat("探索模块B") }
   ```

3. **缓存SubAgent结果**:
   - 同一会话中，重复问题使用缓存结果
   - 减少不必要的重复调用

---

## 📈 测试报告模板

### 功能性测试报告

**测试日期**: ________

**测试人员**: ________

**测试环境**:
- CodeLin版本: Phase 4
- 模型: _______
- 系统: macOS

#### 总体评分: __ / 5 ⭐

#### 各SubAgent评分:

1. **PlannerAgent**: ⭐⭐⭐⭐⭐ / 5
   - 调用准确性: ✅ / ❌
   - 输出质量: ✅ / ❌
   - 建议: _______

2. **ExplorerAgent**: ⭐⭐⭐⭐⭐ / 5
   - 调用准确性: ✅ / ❌
   - 输出质量: ✅ / ❌
   - 建议: _______

3. **EditorAgent**: ⭐⭐⭐⭐⭐ / 5
   - 调用准确性: ✅ / ❌
   - 输出质量: ✅ / ❌
   - 建议: _______

4. **ReviewerAgent**: ⭐⭐⭐⭐⭐ / 5
   - 调用准确性: ✅ / ❌
   - 输出质量: ✅ / ❌
   - 建议: _______

5. **TestGeneratorAgent**: ⭐⭐⭐⭐⭐ / 5
   - 调用准确性: ✅ / ❌
   - 输出质量: ✅ / ❌
   - 建议: _______

6. **RefactoringAgent**: ⭐⭐⭐⭐⭐ / 5
   - 调用准确性: ✅ / ❌
   - 输出质量: ✅ / ❌
   - 建议: _______

#### 协作测试:

- 多SubAgent协作: ✅ / ❌
- 流程顺畅度: ⭐⭐⭐⭐⭐ / 5
- 结果完整性: ✅ / ❌

#### 性能指标:

| 指标 | 目标 | 实际 | 状态 |
|------|------|------|------|
| 平均响应时间 | <5s | __s | ✅ / ❌ |
| 识别准确率 | >80% | __% | ✅ / ❌ |
| 输出有效率 | >90% | __% | ✅ / ❌ |

#### 发现的问题:

1. _______
2. _______
3. _______

#### 改进建议:

1. _______
2. _______
3. _______

#### 下一步行动:

- [ ] 优化Prompt
- [ ] 调整模型配置
- [ ] 增强错误处理
- [ ] 改进进度提示

---

## 🎯 成功标准

测试通过标准：

### 基础功能（必须）
- ✅ 6个SubAgent全部可正常调用
- ✅ 输出格式符合预期（JSON/Markdown）
- ✅ 内容质量达到⭐⭐⭐以上
- ✅ 无系统错误或崩溃

### 性能表现（必须）
- ✅ 平均响应时间 <8s
- ✅ 主Agent识别准确率 >70%
- ✅ SubAgent输出有效率 >85%

### 协作能力（必须）
- ✅ 能自动编排多SubAgent协作
- ✅ SubAgent间信息传递正常
- ✅ 复杂任务能完整交付

### 用户体验（重要）
- ✅ 进度提示清晰
- ✅ 错误信息友好
- ✅ 交互流畅自然

---

## 📝 测试日志示例

```
[2024-10-26 14:30:00] 开始测试
[2024-10-26 14:30:15] 测试PlannerAgent - 通过 ✅
  - 调用成功，返回JSON格式计划
  - 包含5个子任务，依赖关系清晰
  - 评分: ⭐⭐⭐⭐

[2024-10-26 14:32:00] 测试ExplorerAgent - 通过 ✅
  - 正确分析项目结构
  - 识别2个关键文件
  - 评分: ⭐⭐⭐⭐⭐

[2024-10-26 14:35:00] 测试EditorAgent - 通过 ✅
  - 精准修改目标函数
  - 保持代码风格
  - 评分: ⭐⭐⭐⭐

[2024-10-26 14:37:30] 测试ReviewerAgent - 通过 ✅
  - 发现3个潜在问题
  - 提供改进建议
  - 评分: ⭐⭐⭐⭐⭐

[2024-10-26 14:40:00] 测试TestGeneratorAgent - 通过 ✅
  - 生成6个测试用例
  - 覆盖happy/edge/error cases
  - 评分: ⭐⭐⭐⭐

[2024-10-26 14:43:00] 测试RefactoringAgent - 通过 ✅
  - 识别2个code smells
  - 提供具体重构建议
  - 评分: ⭐⭐⭐⭐

[2024-10-26 14:50:00] 测试多SubAgent协作 - 通过 ✅
  - 自动调用4个SubAgent
  - 流程顺畅，结果完整
  - 评分: ⭐⭐⭐⭐⭐

[2024-10-26 14:50:00] 测试完成
总评: ⭐⭐⭐⭐ (4.3/5)
结论: 功能正常，建议优化EditorAgent和TestGeneratorAgent的输出质量
```

---

## 🚀 开始测试

### 快速开始

```bash
# 1. 确保环境正常
cd /Users/louloulin/Documents/linchong/cjproject/codelin
cjpm build

# 2. 启动CodeLin
./scripts/magic-cli.sh

# 3. 按照测试场景逐一测试
# 4. 记录测试结果
# 5. 填写测试报告
```

### 测试顺序建议

1. **单个SubAgent测试**（测试1-6）
   - 从简单到复杂
   - 验证基本功能
   - 记录问题

2. **协作测试**（测试7）
   - 验证整体流程
   - 测试复杂场景
   - 评估用户体验

3. **性能测试**
   - 测量响应时间
   - 监控资源使用
   - 识别瓶颈

4. **压力测试**（可选）
   - 连续多次调用
   - 极端场景测试
   - 稳定性验证

---

**祝测试顺利！** 🎉

如有问题，请参考:
- `PHASE4_COMPLETE_SUCCESS.md` - 实施总结
- `LOGGING_ANALYSIS_REPORT.md` - 日志分析
- `plan4.md` - 完整计划

