# 配置文件重命名方案

**日期**: 2025-11-18 14:35  
**目标**: codelin.json → codelin.json  
**状态**: 规划中

---

## 🎯 改造目标

### 1. 文件名统一
- ❌ `codelin.json` (通用名称)
- ✅ `codelin.json` (品牌化)

### 2. 模型配置
- ✅ 默认模型：`zhipuai:glm-4.6` (已经是智谱 AI)
- ✅ 快速模型：`zhipuai:glm-4-flash`
- ✅ 备用模型：`zhipuai:glm-4`

---

## 📋 需要修改的文件

### 代码文件

#### 1. src/core/config/cli_setting.cj
**位置**: 第 49 行

```cangjie
// 之前
return CliConfig.dotDir.join("codelin.json")

// 之后
return CliConfig.dotDir.join("codelin.json")
```

### 文档文件

#### 2. README.md
- 第 223 行: `.codelin\codelin.json`
- 第 302 行: `codelin.json`

#### 3. docs/mcp.md
- 第 52 行: `.codelin/codelin.json`

#### 4. RECOVERY_SUMMARY.md
- 第 201 行: `.codelin/codelin.json`

#### 5. plan1.md
- 第 952 行: `codelin.json 扩展`

---

## 🔍 影响分析

### 现有用户
- ⚠️  已有 `.codelin/codelin.json` 的用户需要重命名
- ✅ 建议添加兼容性处理

### 新用户
- ✅ 直接使用 `codelin.json`
- ✅ 品牌统一

### Codebin 安装包
- ✅ 已经使用 `codelin.json`
- ✅ 无需修改

---

## 💡 兼容性方案

### 方案 1: 自动迁移（推荐）
```cangjie
private static prop settingFilePath: Path {
    get() {
        let newPath = CliConfig.dotDir.join("codelin.json")
        let oldPath = CliConfig.dotDir.join("codelin.json")
        
        // 如果旧文件存在且新文件不存在，自动迁移
        if (exists(oldPath) && !exists(newPath)) {
            try {
                File.copy(oldPath, newPath)
                LogUtils.info("Migrated codelin.json to codelin.json")
            } catch (e: Exception) {
                LogUtils.warn("Failed to migrate config file: ${e}")
            }
        }
        
        return newPath
    }
}
```

### 方案 2: 仅改名（简单）
```cangjie
private static prop settingFilePath: Path {
    get() {
        return CliConfig.dotDir.join("codelin.json")
    }
}
```

---

## 📝 执行计划

### 步骤 1: 修改核心代码
- [x] 分析现状
- [ ] 修改 cli_setting.cj
- [ ] 添加兼容性处理（可选）

### 步骤 2: 更新文档
- [ ] README.md
- [ ] docs/mcp.md
- [ ] RECOVERY_SUMMARY.md
- [ ] plan1.md

### 步骤 3: 验证
- [ ] 测试新配置文件加载
- [ ] 测试旧文件迁移（如果实现）
- [ ] 验证 MCP 配置

### 步骤 4: 更新安装脚本
- [ ] install-complete.sh
- [ ] 确保生成 codelin.json

---

## ✅ 模型配置验证

### 当前默认值 (cli_setting.cj)
```cangjie
protected var model: String = "zhipuai:glm-4.6"  ✅
protected var fastModel: Option<String> = Some("zhipuai:glm-4-flash")  ✅
protected var fallbackModels: Array<String> = ["zhipuai:glm-4"]  ✅
```

**结论**: 默认模型已经是智谱 AI，无需修改！

---

## 🎨 品牌统一效果

### 之前
```
.codelin/
├── codelin.json       ❌ 通用名称
└── ...
```

### 之后
```
.codelin/
├── codelin.json        ✅ 品牌化
└── ...
```

**一致性**:
- ✅ Codelin CLI
- ✅ CodeLinAgent
- ✅ codelin.json
- ✅ codelin 启动脚本

---

## 📊 风险评估

| 风险 | 等级 | 缓解措施 |
|------|------|----------|
| 破坏现有配置 | 中 | 实现自动迁移 |
| 文档不一致 | 低 | 全面更新文档 |
| 用户困惑 | 低 | 清晰的迁移说明 |

---

## 🚀 建议

1. **实现自动迁移** - 对用户友好
2. **全面更新文档** - 保持一致性
3. **添加日志提示** - 帮助用户理解变更
4. **保留兼容期** - 考虑双向兼容

---

**下一步**: 执行修改
