#!/bin/bash

# CodeLin v6.1 交互式验证脚本
# 使用方法: ./run_cli_interactive.sh

echo "╔══════════════════════════════════════════════════════════════╗"
echo "║         CodeLin v6.1 交互式功能验证                          ║"
echo "╚══════════════════════════════════════════════════════════════╝"
echo ""

# 设置环境
source $CANGJIE_HOME/envsetup.sh

echo "📊 验证前检查:"
echo "  ✅ Cangjie 环境: $(which cjpm)"
echo "  ✅ 项目目录: $(pwd)"
echo "  ✅ 可执行文件: $(ls -lh target/release/bin/cli 2>/dev/null | awk '{print $5}')"
echo ""

echo "🎯 验证内容:"
echo "  1. ExecutionLoopAgent (256行) - 自主执行循环"
echo "  2. BatchEditToolset (349行) - 批量原子性编辑"
echo "  3. 7个 SubAgent 完整功能"
echo "  4. 10个 Toolset 集成验证"
echo ""

echo "📝 建议测试命令 (启动后输入):"
echo "  /help              - 查看所有命令"
echo "  /memory            - 查看项目配置"
echo "  /init              - 初始化项目配置"
echo "  /sessions          - 查看会话列表"
echo "  /mcp list          - 查看 MCP 服务器"
echo ""
echo "  简单问答:"
echo "    > 你好，介绍一下你的功能"
echo "    > 解释 ExecutionLoopAgent 的作用"
echo "    > 创建一个简单的 hello world 函数"
echo ""
echo "  文件引用:"
echo "    > @src/core/agents/subagents/execution_loop_agent.cj 解释这个文件"
echo ""
echo "  Shell 命令:"
echo "    > !ls -la src/core/agents/subagents/"
echo ""
echo "  /exit              - 退出 CLI"
echo ""

echo "⚠️  重要提示:"
echo "  - ExecutionLoopAgent 在后台自动运行 (不是独立命令)"
echo "  - BatchEditToolset 由 Agent 调用 (不是用户命令)"
echo "  - 观察 Agent 响应中的自动验证和重试行为"
echo ""

read -p "按 Enter 键启动 CLI，或 Ctrl+C 取消..."
echo ""

echo "🚀 正在启动 CodeLin CLI..."
echo "════════════════════════════════════════════════════════════════"
echo ""

# 启动 CLI
cjpm run --name cli

echo ""
echo "════════════════════════════════════════════════════════════════"
echo "✅ CLI 已退出"
echo ""
echo "📊 验证后记录:"
echo "  请记录测试结果到: 交互式验证指南.md"
echo ""
