# Mac 上构建 Windows 程序 - 快速参考

## 🎯 核心要点

### Cangjie 交叉编译原理

1. **使用 `--target` 参数**：`cjpm build --target=<target-triple>`
2. **目标平台格式**：`<arch>-<vendor>-<os>-<env>`
3. **Windows 目标**：
   - `x86_64-unknown-windows-gnu` (GNU ABI)
   - `x86_64-w64-mingw32` (MinGW-w64) ⭐ 推荐

### 快速开始

```bash
# 1. 设置环境变量
export MAGIC_PATH=/path/to/magic

# 2. 安装 MinGW-w64（如果未安装）
brew install mingw-w64

# 3. 运行构建脚本
bash scripts/build-windows.sh
```

## 📋 关键配置

### cjpm.toml 中的 Windows 配置

```toml
[target.x86_64-w64-mingw32]
  compile-option = "-lcrypt32"

[target.x86_64-w64-mingw32.bin-dependencies]
  path-option = ["${MAGIC_PATH}/libs/cangjie-stdx-windows-x64-1.0.0.1/windows_x86_64_llvm/static/stdx"]
```

### 必需依赖

1. **Windows 标准库**：`cangjie-stdx-windows-x64-*`
2. **交叉编译工具链**：MinGW-w64 或 Cangjie SDK 工具链
3. **静态链接配置**：使用 `cli-static.toml`

## 🔧 构建命令

### 使用脚本（推荐）

```bash
bash scripts/build-windows.sh [target]
```

### 手动构建

```bash
# 应用静态配置
cp scripts/cli-static.toml cjpm.toml

# 清理
cjpm clean

# 交叉编译
cjpm build --target=x86_64-w64-mingw32 -V
```

## 📁 输出位置

```
binary/windows/codelin-x86_64-w64-mingw32.exe
```

## ⚠️ 常见问题速查

| 问题 | 解决方案 |
|------|---------|
| 找不到工具链 | `brew install mingw-w64` |
| 找不到标准库 | 检查 `$MAGIC_PATH/libs/cangjie-stdx-windows-*` |
| FFI 编译失败 | 使用 MinGW 工具链编译 FFI 库 |
| 静态链接失败 | 确保使用 `cli-static.toml` 配置 |

## 📚 详细文档

- **完整指南**：`scripts/WINDOWS_BUILD_GUIDE.md`
- **构建脚本**：`scripts/build-windows.sh`
- **Cangjie 文档**：https://docs.cangjie-lang.cn

## 🎓 技术细节

### 交叉编译流程

1. **配置阶段**：应用 Windows 目标配置
2. **清理阶段**：清理 FFI 和构建目录
3. **编译阶段**：使用 `--target` 参数交叉编译
4. **输出阶段**：复制二进制文件到 `binary/windows/`

### 工具链选择

- **MinGW-w64**：轻量，适合 Windows 原生环境
- **GNU 工具链**：功能完整，适合复杂项目

### 静态链接优势

- ✅ 不依赖外部 DLL
- ✅ 单文件部署
- ✅ 更好的兼容性

