#!/bin/bash

echo "🧪 UI 功能恢复测试"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""

cd /Users/louloulin/Documents/linchong/gitcode/magic/codelin

echo "📋 Step 1: 检查文件是否存在"
echo ""

files=(
    "src/io/input_utils.cj"
    "src/io/session_display.cj"
    "src/io/session_selector.cj"
    "src/core/conversation/conversation_manager.cj"
)

for file in "${files[@]}"; do
    if [ -f "$file" ]; then
        echo "✅ $file ($(wc -l < "$file") lines)"
    else
        echo "❌ $file 不存在"
    fi
done

echo ""
echo "📋 Step 2: 检查关键方法"
echo ""

echo "input_utils.cj:"
echo "  - buildPrompt: $(grep -c 'func buildPrompt' src/io/input_utils.cj)"
echo "  - getUserInput: $(grep -c 'func getUserInput' src/io/input_utils.cj)"
echo "  - printSessionInfoBar: $(grep -c 'func printSessionInfoBar' src/io/input_utils.cj)"
echo "  - readRune: $(grep -c 'func readRune' src/io/input_utils.cj)"

echo ""
echo "conversation_manager.cj:"
echo "  - getCurrentSessionDisplayInfo: $(grep -c 'getCurrentSessionDisplayInfo' src/core/conversation/conversation_manager.cj)"

echo ""
echo "📋 Step 3: 检查导入"
echo ""

echo "session_selector.cj imports:"
grep "^import" src/io/session_selector.cj | head -5

echo ""
echo "📋 Step 4: Git 状态"
echo ""

git status --short | head -10

echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "✅ 文件检查完成"
