#!/bin/bash
# 测试 Ctrl+D (EOF) 处理

cd "$(dirname "$0")"

echo "========================================"
echo "测试 EOF 处理（模拟 Ctrl+D）"
echo "========================================"
echo ""

echo "测试 1: 使用空输入模拟 EOF"
echo ""
# 使用 /dev/null 作为输入（立即 EOF）
cjpm run --name cli < /dev/null 2>&1 | tail -10

echo ""
echo "========================================"
echo "检查是否有异常"
echo "========================================"

# 检查是否有异常
if cjpm run --name cli < /dev/null 2>&1 | grep -q "Exception.*Read bytes"; then
    echo "❌ 测试失败：仍然抛出异常"
    echo ""
    cjpm run --name cli < /dev/null 2>&1 | grep -A 5 "Exception"
    exit 1
else
    echo "✅ 测试通过：没有抛出异常"
    exit 0
fi

