#!/bin/bash

# 测试自定义 SubAgent 运行时加载功能

set -e

PROJECT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$PROJECT_DIR"

echo "🧪 测试自定义 SubAgent 运行时加载功能"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

# 1. 检查必要的文件是否存在
echo ""
echo "📁 步骤 1: 检查文件"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

FILES=(
    "src/core/agents/custom_agent.cj"
    "src/core/agents/custom_agent_runtime.cj"
    "src/core/agents/custom_agent_config.cj"
    "src/app/cli_app.cj"
)

for file in "${FILES[@]}"; do
    if [ -f "$file" ]; then
        echo "✅ $file"
    else
        echo "❌ $file - 文件不存在"
        exit 1
    fi
done

# 2. 检查 CustomAgent 类是否正确定义
echo ""
echo "📋 步骤 2: 检查 CustomAgent 类定义"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

if grep -q "@agent" src/core/agents/custom_agent.cj; then
    echo "✅ CustomAgent 类使用 @agent 宏定义"
else
    echo "❌ CustomAgent 类未使用 @agent 宏"
    exit 1
fi

if grep -q "class CustomAgent" src/core/agents/custom_agent.cj; then
    echo "✅ CustomAgent 类定义存在"
else
    echo "❌ CustomAgent 类定义不存在"
    exit 1
fi

# 3. 检查 CustomAgentRuntime.createAgentFromConfig 实现
echo ""
echo "🔧 步骤 3: 检查 CustomAgentRuntime 实现"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

if grep -q "createAgentFromConfig" src/core/agents/custom_agent_runtime.cj; then
    echo "✅ createAgentFromConfig 方法存在"
else
    echo "❌ createAgentFromConfig 方法不存在"
    exit 1
fi

if grep -q "CustomAgent(config)" src/core/agents/custom_agent_runtime.cj; then
    echo "✅ 使用 CustomAgent 创建实例"
else
    echo "❌ 未使用 CustomAgent 创建实例"
    exit 1
fi

# 4. 检查 cli_app.cj 中的集成
echo ""
echo "🔗 步骤 4: 检查 cli_app.cj 集成"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

if grep -q "CustomAgentRuntime" src/app/cli_app.cj; then
    echo "✅ cli_app.cj 中导入了 CustomAgentRuntime"
else
    echo "❌ cli_app.cj 中未导入 CustomAgentRuntime"
    exit 1
fi

if grep -q "loadAndIntegrateAgents" src/app/cli_app.cj; then
    echo "✅ cli_app.cj 中调用了 loadAndIntegrateAgents"
else
    echo "❌ cli_app.cj 中未调用 loadAndIntegrateAgents"
    exit 1
fi

# 5. 创建测试配置
echo ""
echo "📝 步骤 5: 创建测试配置"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

TEST_AGENT_DIR="$HOME/.codelin/agents"
mkdir -p "$TEST_AGENT_DIR"

cat > "$TEST_AGENT_DIR/test_agent.toml" << 'EOF'
[agent]
name = "TestAgent"
description = "测试自定义 Agent"
model = "default"
temperature = 0.7

prompt = """
You are a test agent for CodeLin.

Your task is to help users test the custom agent functionality.
Always be helpful and provide clear responses.
"""

tools = [
    "FSToolset",
    "SearchToolset"
]

tags = ["test", "custom"]
EOF

echo "✅ 测试配置已创建: $TEST_AGENT_DIR/test_agent.toml"

# 6. 检查编译
echo ""
echo "🔨 步骤 6: 检查代码编译"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

if command -v cjpm &> /dev/null; then
    echo "✅ cjpm 已安装"
    echo "⚠️  注意: 需要运行 'cjpm build' 来验证编译"
else
    echo "⚠️  cjpm 未安装，跳过编译检查"
fi

# 7. 总结
echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "✅ 所有检查通过！"
echo ""
echo "📋 下一步验证步骤:"
echo "1. 运行 'cjpm build' 编译代码"
echo "2. 运行 'cjpm run --name cli' 启动 CodeLin"
echo "3. 在 CodeLin 中输入 '/agents' 查看自定义 Agent"
echo "4. 验证自定义 Agent 是否已加载并集成"
echo ""
echo "💡 测试配置位置: $TEST_AGENT_DIR/test_agent.toml"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

