#!/bin/bash
# 测试 EOF 异常修复

echo "========================================"
echo "测试 EOF 异常修复"
echo "========================================"
echo ""

cd "$(dirname "$0")"

echo "1. 测试: 模拟 EOF 输入（echo 空字符串）"
echo "   预期: 程序正常启动和退出，不抛出异常"
echo ""
echo "" | timeout 5s ./target/release/codelin 2>&1 | grep -i "exception" || echo "✓ 无异常抛出"
echo ""

echo "2. 测试: 模拟 Ctrl+D（传入 EOF）"
echo "   预期: 程序正常启动和退出，不抛出异常"
echo ""
timeout 5s ./target/release/codelin < /dev/null 2>&1 | grep -i "exception" || echo "✓ 无异常抛出"
echo ""

echo "========================================"
echo "测试完成"
echo "========================================"
echo ""
echo "手动测试步骤:"
echo "1. 运行: ./target/release/codelin"
echo "2. 按 Ctrl+D"
echo "3. 验证程序优雅退出，无异常信息"
echo ""

