#!/bin/bash

# Test script for P0-1: MCP Prompt Emergency Fix Implementation
# This script verifies that the MCP prompt implementation is working correctly

set -e

echo "=========================================="
echo "Testing P0-1: MCP Prompt Implementation"
echo "=========================================="
echo ""

# Colors for output
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Test 1: Check if MCP prompt module exists
echo -e "${YELLOW}Test 1: Checking MCP prompt module...${NC}"
if [ -f "src/core/agents/mcp_prompt.cj" ]; then
    echo -e "${GREEN}✓ MCP prompt module exists${NC}"
else
    echo -e "${RED}✗ MCP prompt module not found${NC}"
    exit 1
fi

# Test 2: Check if MCPToolWrapper is enhanced
echo -e "${YELLOW}Test 2: Checking MCPToolWrapper enhancement...${NC}"
if grep -q "enhanceDescriptionByKeywords" src/core/mcp/wrapper.cj; then
    echo -e "${GREEN}✓ MCPToolWrapper has intelligent enhancement${NC}"
else
    echo -e "${RED}✗ MCPToolWrapper enhancement not found${NC}"
    exit 1
fi

# Test 3: Check if tool list generator exists
echo -e "${YELLOW}Test 3: Checking tool list generator...${NC}"
if [ -f "src/core/agents/tool_list_generator.cj" ]; then
    echo -e "${GREEN}✓ Tool list generator exists${NC}"
else
    echo -e "${RED}✗ Tool list generator not found${NC}"
    exit 1
fi

# Test 4: Check if agent list generator exists
echo -e "${YELLOW}Test 4: Checking agent list generator...${NC}"
if [ -f "src/core/agents/agent_list_generator.cj" ]; then
    echo -e "${GREEN}✓ Agent list generator exists${NC}"
else
    echo -e "${RED}✗ Agent list generator not found${NC}"
    exit 1
fi

# Test 5: Check if General Agent imports MCP prompt
echo -e "${YELLOW}Test 5: Checking General Agent integration...${NC}"
if grep -q "MCPPrompt" src/core/agents/general_code_agent.cj; then
    echo -e "${GREEN}✓ General Agent imports MCP prompt${NC}"
else
    echo -e "${RED}✗ General Agent does not import MCP prompt${NC}"
    exit 1
fi

# Test 6: Check if Cangjie Agent imports MCP prompt
echo -e "${YELLOW}Test 6: Checking Cangjie Agent integration...${NC}"
if grep -q "MCPPrompt" src/core/agents/cangjie_code_agent.cj; then
    echo -e "${GREEN}✓ Cangjie Agent imports MCP prompt${NC}"
else
    echo -e "${RED}✗ Cangjie Agent does not import MCP prompt${NC}"
    exit 1
fi

# Test 7: Check if MCP prompt is used in General Agent prompt
echo -e "${YELLOW}Test 7: Checking MCP prompt usage in General Agent...${NC}"
if grep -q "MCPPrompt.MCP_TOOLS_PROMPT" src/core/agents/general_code_agent.cj; then
    echo -e "${GREEN}✓ MCP prompt is used in General Agent${NC}"
else
    echo -e "${RED}✗ MCP prompt not used in General Agent${NC}"
    exit 1
fi

# Test 8: Check if MCP prompt is used in Cangjie Agent prompt
echo -e "${YELLOW}Test 8: Checking MCP prompt usage in Cangjie Agent...${NC}"
if grep -q "MCPPrompt.MCP_TOOLS_PROMPT" src/core/agents/cangjie_code_agent.cj; then
    echo -e "${GREEN}✓ MCP prompt is used in Cangjie Agent${NC}"
else
    echo -e "${RED}✗ MCP prompt not used in Cangjie Agent${NC}"
    exit 1
fi

# Test 9: Verify no hardcoded server names in MCP prompt
echo -e "${YELLOW}Test 9: Verifying no hardcoded server names...${NC}"
if ! grep -q "mcp_mastra\|mcp_context7\|mcp_cursor" src/core/agents/mcp_prompt.cj; then
    echo -e "${GREEN}✓ No hardcoded server names in MCP prompt${NC}"
else
    echo -e "${RED}✗ Found hardcoded server names in MCP prompt${NC}"
    exit 1
fi

# Test 10: Check MCPToolWrapper uses pattern matching
echo -e "${YELLOW}Test 10: Checking MCPToolWrapper uses pattern matching...${NC}"
if grep -q "match.*toolType" src/core/mcp/wrapper.cj; then
    echo -e "${GREEN}✓ MCPToolWrapper uses pattern matching for tool type detection${NC}"
else
    echo -e "${RED}✗ MCPToolWrapper does not use pattern matching${NC}"
    exit 1
fi

echo ""
echo -e "${GREEN}=========================================="
echo "All tests passed! ✓"
echo "==========================================${NC}"
echo ""
echo "Summary:"
echo "  ✓ MCP prompt module created (generic, no hardcoding)"
echo "  ✓ MCPToolWrapper enhanced with intelligent description"
echo "  ✓ Tool list generator implemented"
echo "  ✓ Agent list generator implemented"
echo "  ✓ Both agents integrated with MCP prompt"
echo "  ✓ No hardcoded server names"
echo ""
echo "Next steps:"
echo "  - Test MCP tool usage in actual agent interactions"
echo "  - Verify MCP tools are correctly identified and used"
echo "  - Monitor MCP tool usage rate (target: >20%)"

