#!/bin/bash

# Test script for P0-2: Prompt Simplification
# This script verifies that the prompt has been simplified correctly

set -e

echo "=========================================="
echo "Testing P0-2: Prompt Simplification"
echo "=========================================="
echo ""

# Colors for output
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Test 1: Check prompt line count
echo -e "${YELLOW}Test 1: Checking prompt line count...${NC}"
LINE_COUNT=$(wc -l < src/core/agents/general_code_agent.cj)
if [ "$LINE_COUNT" -lt 300 ]; then
    echo -e "${GREEN}✓ Prompt reduced to ${LINE_COUNT} lines (target: <300 lines)${NC}"
else
    echo -e "${RED}✗ Prompt still too long: ${LINE_COUNT} lines${NC}"
    exit 1
fi

# Test 2: Verify detailed SubAgent descriptions removed
echo -e "${YELLOW}Test 2: Checking detailed SubAgent descriptions removed...${NC}"
if ! grep -q "**Expertise**: Breaking down complex requirements" src/core/agents/general_code_agent.cj; then
    echo -e "${GREEN}✓ Detailed SubAgent descriptions removed from main prompt${NC}"
else
    echo -e "${RED}✗ Detailed SubAgent descriptions still present${NC}"
    exit 1
fi

# Test 3: Verify brief SubAgent reference remains
echo -e "${YELLOW}Test 3: Checking brief SubAgent reference remains...${NC}"
if grep -q "You have access to specialized SubAgents" src/core/agents/general_code_agent.cj; then
    echo -e "${GREEN}✓ Brief SubAgent reference remains${NC}"
else
    echo -e "${RED}✗ Brief SubAgent reference missing${NC}"
    exit 1
fi

# Test 4: Verify working directory rule remains
echo -e "${YELLOW}Test 4: Checking working directory rule remains...${NC}"
if grep -q "MANDATORY.*working directory" src/core/agents/general_code_agent.cj; then
    echo -e "${GREEN}✓ Working directory rule preserved${NC}"
else
    echo -e "${RED}✗ Working directory rule missing${NC}"
    exit 1
fi

# Test 5: Verify no duplicate SubAgent sections
echo -e "${YELLOW}Test 5: Checking for duplicate SubAgent sections...${NC}"
SUBAGENT_COUNT=$(grep -c "#.*SubAgent Collaboration System" src/core/agents/general_code_agent.cj || true)
if [ "$SUBAGENT_COUNT" -le 1 ]; then
    echo -e "${GREEN}✓ No duplicate SubAgent sections${NC}"
else
    echo -e "${RED}✗ Found ${SUBAGENT_COUNT} SubAgent sections (should be 1)${NC}"
    exit 1
fi

# Test 6: Verify MCP prompt integration
echo -e "${YELLOW}Test 6: Checking MCP prompt integration...${NC}"
if grep -q "MCPPrompt.MCP_TOOLS_PROMPT" src/core/agents/general_code_agent.cj; then
    echo -e "${GREEN}✓ MCP prompt integrated${NC}"
else
    echo -e "${RED}✗ MCP prompt not integrated${NC}"
    exit 1
fi

# Test 7: Calculate reduction percentage
echo -e "${YELLOW}Test 7: Calculating reduction...${NC}"
ORIGINAL_LINES=646
CURRENT_LINES=$LINE_COUNT
REDUCTION=$((ORIGINAL_LINES - CURRENT_LINES))
REDUCTION_PERCENT=$((REDUCTION * 100 / ORIGINAL_LINES))
echo -e "${GREEN}✓ Reduced from ${ORIGINAL_LINES} to ${CURRENT_LINES} lines (${REDUCTION} lines, ${REDUCTION_PERCENT}% reduction)${NC}"

if [ "$REDUCTION_PERCENT" -ge 70 ]; then
    echo -e "${GREEN}✓ Excellent reduction! Exceeded 70% target${NC}"
fi

echo ""
echo -e "${GREEN}=========================================="
echo "All tests passed! ✓"
echo "==========================================${NC}"
echo ""
echo "Summary:"
echo "  ✓ Prompt simplified from 646 to ${CURRENT_LINES} lines"
echo "  ✓ Detailed SubAgent descriptions removed"
echo "  ✓ Brief SubAgent reference preserved"
echo "  ✓ Working directory rule preserved"
echo "  ✓ No duplicate sections"
echo "  ✓ MCP prompt integrated"
echo ""
echo "Reduction: ${REDUCTION} lines (${REDUCTION_PERCENT}%)"

