#!/bin/bash

# Test script for P0: Dynamic Tool and Agent List Injection
# Verifies that dynamic list generators are integrated into agent prompts

echo "=========================================="
echo "Testing P0: Dynamic List Injection"
echo "=========================================="
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m'

PASSED=0
FAILED=0

test_check() {
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓${NC} $1"
        ((PASSED++))
    else
        echo -e "${RED}✗${NC} $1"
        ((FAILED++))
    fi
}

# Test 1: PromptFormatter imported in General Agent
echo -e "${YELLOW}Test 1: PromptFormatter imported in General Agent...${NC}"
if grep -q "prompt_formatter" src/core/agents/general_code_agent.cj; then
    test_check "PromptFormatter imported in General Agent"
else
    echo -e "${RED}✗${NC} PromptFormatter imported in General Agent"
    ((FAILED++))
fi

# Test 2: General Agent uses PLACEHOLDER tokens
echo -e "${YELLOW}Test 2: PLACEHOLDER usage in General Agent...${NC}"
if grep -q "PLACEHOLDER" src/core/agents/general_code_agent.cj; then
    test_check "PLACEHOLDER used in General Agent"
else
    echo -e "${RED}✗${NC} PLACEHOLDER used in General Agent"
    ((FAILED++))
fi

# Test 3: Check dynamic tool list injection
echo -e "${YELLOW}Test 3: Dynamic tool list injection in General Agent...${NC}"
if grep -q "ToolListGenerator.generateToolList" src/core/agents/general_code_agent.cj || \
   grep -q "PLACEHOLDER.TOOLS_PROMPT" src/core/agents/general_code_agent.cj; then
    test_check "Dynamic tool list injection in General Agent"
else
    echo -e "${RED}✗${NC} Dynamic tool list injection in General Agent"
    ((FAILED++))
fi

# Test 4: Check dynamic agent list injection
echo -e "${YELLOW}Test 4: Dynamic agent list injection in General Agent...${NC}"
if grep -q "AgentListGenerator.generateAgentList" src/core/agents/general_code_agent.cj || \
   grep -q "PLACEHOLDER.AGENTS_PROMPT" src/core/agents/general_code_agent.cj; then
    test_check "Dynamic agent list injection in General Agent"
else
    echo -e "${RED}✗${NC} Dynamic agent list injection in General Agent"
    ((FAILED++))
fi

# Test 5: PromptFormatter imported in Cangjie Agent
echo -e "${YELLOW}Test 5: PromptFormatter imported in Cangjie Agent...${NC}"
if grep -q "prompt_formatter" src/core/agents/cangjie_code_agent.cj; then
    test_check "PromptFormatter imported in Cangjie Agent"
else
    echo -e "${RED}✗${NC} PromptFormatter imported in Cangjie Agent"
    ((FAILED++))
fi

# Test 6: Check Cangjie Agent dynamic injection
echo -e "${YELLOW}Test 6: Dynamic lists injected in Cangjie Agent...${NC}"
if (grep -q "ToolListGenerator.generateToolList" src/core/agents/cangjie_code_agent.cj || \
    grep -q "PLACEHOLDER.TOOLS_PROMPT" src/core/agents/cangjie_code_agent.cj) && \
   (grep -q "AgentListGenerator.generateAgentList" src/core/agents/cangjie_code_agent.cj || \
    grep -q "PLACEHOLDER.AGENTS_PROMPT" src/core/agents/cangjie_code_agent.cj); then
    test_check "Dynamic lists injected in Cangjie Agent"
else
    echo -e "${RED}✗${NC} Dynamic lists injected in Cangjie Agent"
    ((FAILED++))
fi

# Test 7: Check "Available Tools" section
echo -e "${YELLOW}Test 7: 'Available Tools' section in prompts...${NC}"
if grep -q "## Available Tools" src/core/agents/general_code_agent.cj && grep -q "## Available Tools" src/core/agents/cangjie_code_agent.cj; then
    test_check "'Available Tools' section in both agents"
else
    echo -e "${RED}✗${NC} 'Available Tools' section in both agents"
    ((FAILED++))
fi

# Test 8: Check "Available SubAgents" section
echo -e "${YELLOW}Test 8: 'Available SubAgents' section in prompts...${NC}"
if grep -q "## Available SubAgents" src/core/agents/general_code_agent.cj && grep -q "## Available SubAgents" src/core/agents/cangjie_code_agent.cj; then
    test_check "'Available SubAgents' section in both agents"
else
    echo -e "${RED}✗${NC} 'Available SubAgents' section in both agents"
    ((FAILED++))
fi

# Test 9: PromptFormatter wires dynamic replacements
echo -e "${YELLOW}Test 9: PromptFormatter generates tool/agent lists...${NC}"
if grep -q "ToolListGenerator.generateToolList" src/core/agents/prompt_formatter.cj && \
   grep -q "AgentListGenerator.generateAgentList" src/core/agents/prompt_formatter.cj; then
    test_check "PromptFormatter wires dynamic lists"
else
    echo -e "${RED}✗${NC} PromptFormatter wires dynamic lists"
    ((FAILED++))
fi

# Summary
echo ""
echo -e "${YELLOW}=== Summary ===${NC}"
echo ""
echo "Tests Passed: ${PASSED}"
echo "Tests Failed: ${FAILED}"
echo ""

if [ $FAILED -eq 0 ]; then
    echo -e "${GREEN}=========================================="
    echo "All tests passed! ✓"
    echo "==========================================${NC}"
    exit 0
else
    echo -e "${RED}=========================================="
    echo "Some tests failed! ✗"
    echo "==========================================${NC}"
    exit 1
fi

