#!/bin/bash

# Test script for P1-3: Tool System Optimization
# Verifies that tool categorization and concise formatting are implemented

# No set -e here to allow all tests to run even if one fails

echo "=========================================="
echo "Testing P1-3: Tool System Optimization"
echo "=========================================="
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m'

PASSED=0
FAILED=0

test_check() {
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓${NC} $1"
        ((PASSED++))
    else
        echo -e "${RED}✗${NC} $1"
        ((FAILED++))
    fi
}

# Test 1: Check categorizeTools function exists
echo -e "${YELLOW}Test 1: categorizeTools function exists...${NC}"
if grep -q "categorizeTools" src/core/agents/tool_list_generator.cj; then
    test_check "categorizeTools function exists"
else
    echo -e "${RED}✗${NC} categorizeTools function exists"
    ((FAILED++))
fi

# Test 2: Check formatToolDescription has concise parameter
echo -e "${YELLOW}Test 2: formatToolDescription has concise parameter...${NC}"
if grep -q "formatToolDescription(tool: Tool, concise:" src/core/agents/tool_list_generator.cj; then
    test_check "formatToolDescription has concise parameter"
else
    echo -e "${RED}✗${NC} formatToolDescription has concise parameter"
    ((FAILED++))
fi

# Test 3: Check tool categories are defined
echo -e "${YELLOW}Test 3: Tool categories are defined...${NC}"
if grep -q "\"file\"" src/core/agents/tool_list_generator.cj && \
   grep -q "\"analysis\"" src/core/agents/tool_list_generator.cj && \
   grep -q "\"execution\"" src/core/agents/tool_list_generator.cj && \
   grep -q "\"planning\"" src/core/agents/tool_list_generator.cj && \
   grep -q "\"advanced\"" src/core/agents/tool_list_generator.cj; then
    test_check "Tool categories are defined"
else
    echo -e "${RED}✗${NC} Tool categories are defined"
    ((FAILED++))
fi

# Test 4: Check category headers in generateToolList
echo -e "${YELLOW}Test 4: Category headers in generateToolList...${NC}"
if grep -q "File Operations (Most Common)" src/core/agents/tool_list_generator.cj && \
   grep -q "Code Analysis" src/core/agents/tool_list_generator.cj && \
   grep -q "Execution" src/core/agents/tool_list_generator.cj && \
   grep -q "Planning & Tasks" src/core/agents/tool_list_generator.cj && \
   grep -q "Advanced (Use when needed)" src/core/agents/tool_list_generator.cj; then
    test_check "Category headers in generateToolList"
else
    echo -e "${RED}✗${NC} Category headers in generateToolList"
    ((FAILED++))
fi

# Test 5: Check Pro Tip message
echo -e "${YELLOW}Test 5: Pro Tip message included...${NC}"
if grep -q "Pro Tip.*Tools are your friends" src/core/agents/tool_list_generator.cj; then
    test_check "Pro Tip message included"
else
    echo -e "${RED}✗${NC} Pro Tip message included"
    ((FAILED++))
fi

# Test 6: Check concise description extraction logic
echo -e "${YELLOW}Test 6: Concise description extraction logic...${NC}"
if grep -q "firstSentence" src/core/agents/tool_list_generator.cj && \
   grep -q "indexOf" src/core/agents/tool_list_generator.cj; then
    test_check "Concise description extraction logic"
else
    echo -e "${RED}✗${NC} Concise description extraction logic"
    ((FAILED++))
fi

# Test 7: Check pattern matching for categorization
echo -e "${YELLOW}Test 7: Pattern matching for categorization...${NC}"
if grep -q "name.contains" src/core/agents/tool_list_generator.cj && \
   grep -q "desc.contains" src/core/agents/tool_list_generator.cj; then
    test_check "Pattern matching for categorization"
else
    echo -e "${RED}✗${NC} Pattern matching for categorization"
    ((FAILED++))
fi

# Test 8: Check tool categorization covers main categories
echo -e "${YELLOW}Test 8: Tool categorization covers main categories...${NC}"
if grep -q "File Operations" src/core/agents/tool_list_generator.cj && \
   grep -q "Code Analysis" src/core/agents/tool_list_generator.cj && \
   grep -q "Execution" src/core/agents/tool_list_generator.cj; then
    test_check "Tool categorization covers main categories"
else
    echo -e "${RED}✗${NC} Tool categorization covers main categories"
    ((FAILED++))
fi

# Summary
echo ""
echo -e "${YELLOW}=== Summary ===${NC}"
echo ""
echo "Tests Passed: ${PASSED}"
echo "Tests Failed: ${FAILED}"
echo ""

if [ $FAILED -eq 0 ]; then
    echo -e "${GREEN}=========================================="
    echo "All tests passed! ✓"
    echo "==========================================${NC}"
    exit 0
else
    echo -e "${RED}=========================================="
    echo "Some tests failed! ✗"
    echo "==========================================${NC}"
    exit 1
fi

