#!/bin/bash

# Phase 5 完整功能测试脚本
# 测试所有 Session 管理功能和 UI 优化

echo "════════════════════════════════════════════════════════════════"
echo "  Phase 5 Complete Functional Test Suite"
echo "════════════════════════════════════════════════════════════════"
echo ""

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# 测试计数器
TOTAL_TESTS=0
PASSED_TESTS=0
FAILED_TESTS=0

# 测试函数
run_test() {
    local test_name="$1"
    local test_cmd="$2"
    local expected_pattern="$3"
    
    TOTAL_TESTS=$((TOTAL_TESTS + 1))
    echo -e "${BLUE}Test $TOTAL_TESTS: $test_name${NC}"
    echo "Running: $test_cmd"
    
    result=$(eval "$test_cmd" 2>&1)
    
    if echo "$result" | grep -q "$expected_pattern"; then
        echo -e "${GREEN}✓ PASSED${NC}"
        PASSED_TESTS=$((PASSED_TESTS + 1))
        return 0
    else
        echo -e "${RED}✗ FAILED${NC}"
        echo "Expected pattern: $expected_pattern"
        echo "Actual output:"
        echo "$result" | head -20
        FAILED_TESTS=$((FAILED_TESTS + 1))
        return 1
    fi
    echo ""
}

cd /Users/louloulin/Documents/linchong/cjproject/codelin

echo "──────────────────────────────────────────────────────────────"
echo "  Phase 0: Build Verification"
echo "──────────────────────────────────────────────────────────────"
echo ""

run_test "Compile CodeLin" \
    "cjpm build 2>&1" \
    "Build success"

echo ""
echo "──────────────────────────────────────────────────────────────"
echo "  Phase 1: Session Metadata Tests"
echo "──────────────────────────────────────────────────────────────"
echo ""

run_test "Session metadata persistence" \
    "ls -la .codelin/sessions/metadata/ 2>&1" \
    "last-conversation.json"

run_test "Metadata contains title field" \
    "cat .codelin/sessions/metadata/last-conversation.json 2>&1" \
    "title"

run_test "Metadata contains messageCount" \
    "cat .codelin/sessions/metadata/last-conversation.json 2>&1" \
    "messageCount"

echo ""
echo "──────────────────────────────────────────────────────────────"
echo "  Phase 2: Session Commands Tests"
echo "──────────────────────────────────────────────────────────────"
echo ""

run_test "/sessions command in help" \
    "echo '/help' | cjpm run --name cli 2>&1" \
    "/sessions"

run_test "/new command in help" \
    "echo '/help' | cjpm run --name cli 2>&1" \
    "/new"

run_test "/switch command in help" \
    "echo '/help' | cjpm run --name cli 2>&1" \
    "/switch"

run_test "/rename command in help" \
    "echo '/help' | cjpm run --name cli 2>&1" \
    "/rename"

echo ""
echo "──────────────────────────────────────────────────────────────"
echo "  Phase 3: UI Display Tests"
echo "──────────────────────────────────────────────────────────────"
echo ""

run_test "Welcome shows /new command" \
    "echo 'exit' | cjpm run --name cli 2>&1" \
    "/new"

run_test "Welcome shows /sessions command" \
    "echo 'exit' | cjpm run --name cli 2>&1" \
    "/sessions"

run_test "/sessions shows simplified UI" \
    "echo -e '/sessions\nexit' | cjpm run --name cli 2>&1" \
    "Sessions ("

run_test "/sessions shows active marker" \
    "echo -e '/sessions\nexit' | cjpm run --name cli 2>&1" \
    "▶"

run_test "/sessions shows commands hint" \
    "echo -e '/sessions\nexit' | cjpm run --name cli 2>&1" \
    "Commands:"

echo ""
echo "──────────────────────────────────────────────────────────────"
echo "  Phase 4: Session Operations Tests"
echo "──────────────────────────────────────────────────────────────"
echo ""

run_test "/rename changes session title" \
    "echo -e '/rename Test Session\n/sessions\nexit' | cjpm run --name cli 2>&1" \
    "Test Session"

run_test "Session indicator shows title" \
    "echo -e '/rename My Project\ntest\nexit' | cjpm run --name cli 2>&1 | grep -A 2 'My Project'" \
    "My Project"

echo ""
echo "──────────────────────────────────────────────────────────────"
echo "  Phase 5: File Structure Tests"
echo "──────────────────────────────────────────────────────────────"
echo ""

run_test "session_metadata.cj exists" \
    "test -f src/core/conversation/session_metadata.cj && echo 'exists'" \
    "exists"

run_test "session_auto_namer.cj exists" \
    "test -f src/core/conversation/session_auto_namer.cj && echo 'exists'" \
    "exists"

run_test "Metadata directory structure" \
    "test -d .codelin/sessions/metadata && echo 'exists'" \
    "exists"

echo ""
echo "──────────────────────────────────────────────────────────────"
echo "  Phase 6: Auto-naming Tests (Simulated)"
echo "──────────────────────────────────────────────────────────────"
echo ""

run_test "SessionAutoNamer class exists" \
    "grep -r 'class SessionAutoNamer' src/ 2>&1" \
    "SessionAutoNamer"

run_test "AI-powered naming function exists" \
    "grep -r '@ai\[' src/core/conversation/session_auto_namer.cj 2>&1" \
    "@ai"

echo ""
echo "════════════════════════════════════════════════════════════════"
echo "  Test Results Summary"
echo "════════════════════════════════════════════════════════════════"
echo ""
echo -e "Total Tests:  ${BLUE}$TOTAL_TESTS${NC}"
echo -e "Passed:       ${GREEN}$PASSED_TESTS${NC}"
echo -e "Failed:       ${RED}$FAILED_TESTS${NC}"
echo ""

if [ $FAILED_TESTS -eq 0 ]; then
    echo -e "${GREEN}════════════════════════════════════════════════════════════════${NC}"
    echo -e "${GREEN}  ✓ ALL TESTS PASSED! Phase 5 implementation complete!${NC}"
    echo -e "${GREEN}════════════════════════════════════════════════════════════════${NC}"
    exit 0
else
    echo -e "${RED}════════════════════════════════════════════════════════════════${NC}"
    echo -e "${RED}  ✗ Some tests failed. Please review the output above.${NC}"
    echo -e "${RED}════════════════════════════════════════════════════════════════${NC}"
    exit 1
fi



