#!/bin/bash

# Phase 5 Runtime Testing Script
# Tests actual CLI execution with Phase 5 commands

set -e

echo "========================================="
echo "Phase 5 Runtime Testing"
echo "========================================="
echo ""

# Colors
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# Clean up test sessions
echo "Cleaning up test sessions..."
rm -rf ~/.codelin/sessions/test-* || true
echo ""

echo -e "${BLUE}Test 1: Running CLI with /help command${NC}"
echo "/help" | timeout 30 cjpm run --name cli 2>&1 | head -50 || true
echo ""

echo -e "${BLUE}Test 2: Testing /sessions command${NC}"
echo "/sessions" | timeout 30 cjpm run --name cli 2>&1 | grep -A 10 "Your Sessions\|No sessions" || echo "Command executed"
echo ""

echo -e "${BLUE}Test 3: Testing /new command${NC}"
echo "/new" | timeout 30 cjpm run --name cli 2>&1 | grep "new session\|Started\|Created" || echo "Command executed"
echo ""

echo -e "${BLUE}Test 4: Check if help shows new commands${NC}"
echo "/help" | timeout 30 cjpm run --name cli 2>&1 | grep -E "/new|/sessions|/switch|/rename" && echo -e "${GREEN}✓ New commands found in help${NC}" || echo -e "${YELLOW}⚠ New commands may not be in help text${NC}"
echo ""

echo -e "${BLUE}Test 5: Verify conversation command still works${NC}"
echo "/conversation" | timeout 30 cjpm run --name cli 2>&1 | grep -A 5 "Conversation Management\|Available Conversations" || echo "Command executed"
echo ""

echo -e "${GREEN}========================================="
echo "Runtime tests completed"
echo "=========================================${NC}"
echo ""
echo "Note: These tests verify basic command execution."
echo "For full interactive testing, please run:"
echo "  cjpm run --name cli"
echo ""
echo "Then try:"
echo "  /new           - Start new session"
echo "  /sessions      - List all sessions"
echo "  /rename <title> - Rename current session"
echo "  /help          - See all commands"

